/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.dece;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TrickPlayBox
extends AbstractFullBox {
    public static final String TYPE = "trik";
    private List<Entry> entries = new ArrayList<Entry>();

    public TrickPlayBox() {
        super(TYPE);
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    protected long getContentSize() {
        return 4 + this.entries.size();
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        while (byteBuffer.remaining() > 0) {
            this.entries.add(new Entry(IsoTypeReader.readUInt8(byteBuffer)));
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt8(byteBuffer, entry.value);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TrickPlayBox");
        stringBuilder.append("{entries=").append(this.entries);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class Entry {
        private int value;

        public Entry() {
        }

        public Entry(int n) {
            this.value = n;
        }

        public int getPicType() {
            return this.value >> 6 & 3;
        }

        public void setPicType(int n) {
            this.value &= 0x1F;
            this.value = (n & 3) << 6 | this.value;
        }

        public int getDependencyLevel() {
            return this.value & 0x3F;
        }

        public void setDependencyLevel(int n) {
            this.value = n & 0x3F | this.value;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Entry");
            stringBuilder.append("{picType=").append(this.getPicType());
            stringBuilder.append(",dependencyLevel=").append(this.getDependencyLevel());
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }
}

