/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MetaBox
extends AbstractContainerBox {
    private int version = 0;
    private int flags = 0;
    public static final String TYPE = "meta";

    public MetaBox() {
        super(TYPE);
    }

    @Override
    public long getContentSize() {
        if (this.isMp4Box()) {
            return 4L + super.getContentSize();
        }
        return super.getContentSize();
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.get(new byte[4]);
        String string = IsoTypeReader.read4cc(byteBuffer);
        if ("hdlr".equals(string)) {
            byteBuffer.position(n);
            this.version = -1;
            this.flags = -1;
        } else {
            byteBuffer.position(n);
            this.version = IsoTypeReader.readUInt8(byteBuffer);
            this.flags = IsoTypeReader.readUInt24(byteBuffer);
        }
        while (byteBuffer.remaining() >= 8) {
            try {
                this.addBox(this.boxParser.parseBox(new ByteBufferByteChannel(byteBuffer), this));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Sebastian needs to fix 7518765283");
            }
        }
        if (byteBuffer.remaining() > 0) {
            throw new RuntimeException("Sebastian needs to fix it 90732r26537");
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        if (this.isMp4Box()) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.version);
            IsoTypeWriter.writeUInt24(byteBuffer, this.flags);
        }
        this.writeChildBoxes(byteBuffer);
    }

    public boolean isMp4Box() {
        return this.version != -1 && this.flags != -1;
    }

    public void setMp4Box(boolean bl) {
        if (bl) {
            this.version = 0;
            this.flags = 0;
        } else {
            this.version = -1;
            this.flags = -1;
        }
    }
}

