/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class DescriptionBox
extends AbstractFullBox {
    public static final String TYPE = "dscp";
    private String language;
    private String description;

    public DescriptionBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected long getContentSize() {
        return 7 + Utf8.utf8StringLengthInBytes(this.description);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.language = IsoTypeReader.readIso639(byteBuffer);
        this.description = IsoTypeReader.readString(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.description));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        return "DescriptionBox[language=" + this.getLanguage() + ";description=" + this.getDescription() + "]";
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

