/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositionTimeToSample
extends AbstractFullBox {
    public static final String TYPE = "ctts";
    List<Entry> entries = Collections.emptyList();

    public CompositionTimeToSample() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 8 + 8 * this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        int n = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.entries = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            Entry entry = new Entry(CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer)), byteBuffer.getInt());
            this.entries.add(entry);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getCount());
            byteBuffer.putInt(entry.getOffset());
        }
    }

    public static int[] blowupCompositionTimes(List<Entry> list) {
        long l = 0L;
        for (Entry entry : list) {
            l += (long)entry.getCount();
        }
        assert (l <= Integer.MAX_VALUE);
        Object object = new int[(int)l];
        int n = 0;
        for (Entry entry : list) {
            for (int i = 0; i < entry.getCount(); ++i) {
                object[n++] = entry.getOffset();
            }
        }
        return object;
    }

    public static class Entry {
        int count;
        int offset;

        public Entry(int n, int n2) {
            this.count = n;
            this.offset = n2;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setCount(int n) {
            this.count = n;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", offset=" + this.offset + '}';
        }
    }
}

