/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.Utf8;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class ClassificationBox
extends AbstractFullBox {
    public static final String TYPE = "clsf";
    private String classificationEntity;
    private int classificationTableIndex;
    private String language;
    private String classificationInfo;

    public ClassificationBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getClassificationEntity() {
        return this.classificationEntity;
    }

    public int getClassificationTableIndex() {
        return this.classificationTableIndex;
    }

    public String getClassificationInfo() {
        return this.classificationInfo;
    }

    public void setClassificationEntity(String string) {
        this.classificationEntity = string;
    }

    public void setClassificationTableIndex(int n) {
        this.classificationTableIndex = n;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setClassificationInfo(String string) {
        this.classificationInfo = string;
    }

    @Override
    protected long getContentSize() {
        return 8 + Utf8.utf8StringLengthInBytes(this.classificationInfo) + 1;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        this.classificationEntity = IsoFile.bytesToFourCC(byArray);
        this.classificationTableIndex = IsoTypeReader.readUInt16(byteBuffer);
        this.language = IsoTypeReader.readIso639(byteBuffer);
        this.classificationInfo = IsoTypeReader.readString(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        byteBuffer.put(IsoFile.fourCCtoBytes(this.classificationEntity));
        IsoTypeWriter.writeUInt16(byteBuffer, this.classificationTableIndex);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.classificationInfo));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ClassificationBox[language=").append(this.getLanguage());
        stringBuilder.append("classificationEntity=").append(this.getClassificationEntity());
        stringBuilder.append(";classificationTableIndex=").append(this.getClassificationTableIndex());
        stringBuilder.append(";language=").append(this.getLanguage());
        stringBuilder.append(";classificationInfo=").append(this.getClassificationInfo());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

