/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractBoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.Box;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyBoxParserImpl
extends AbstractBoxParser {
    Properties mapping;
    Pattern constuctorPattern = Pattern.compile("(.*)\\((.*?)\\)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyBoxParserImpl(String ... stringArray) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream("/isoparser-default.properties"));
        try {
            this.mapping = new Properties();
            try {
                this.mapping.load(bufferedInputStream);
                Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("isoparser-custom.properties");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(uRL.openStream());
                    try {
                        this.mapping.load(bufferedInputStream2);
                    }
                    finally {
                        ((InputStream)bufferedInputStream2).close();
                    }
                }
                for (String string : stringArray) {
                    this.mapping.load(new BufferedInputStream(this.getClass().getResourceAsStream(string)));
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public PropertyBoxParserImpl(Properties properties) {
        this.mapping = properties;
    }

    @Override
    public Class<? extends Box> getClassForFourCc(String string, byte[] byArray, String string2) {
        FourCcToBox fourCcToBox = new FourCcToBox(string, byArray, string2).invoke();
        try {
            return Class.forName(fourCcToBox.clazzName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public Box createBox(String string, byte[] byArray, String string2) {
        FourCcToBox fourCcToBox = new FourCcToBox(string, byArray, string2).invoke();
        String[] stringArray = fourCcToBox.getParam();
        String string3 = fourCcToBox.getClazzName();
        try {
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[stringArray.length];
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if ("userType".equals(stringArray[i])) {
                    objectArray[i] = byArray;
                    classArray[i] = byte[].class;
                    continue;
                }
                if ("type".equals(stringArray[i])) {
                    objectArray[i] = string;
                    classArray[i] = String.class;
                    continue;
                }
                if ("parent".equals(stringArray[i])) {
                    objectArray[i] = string2;
                    classArray[i] = String.class;
                    continue;
                }
                throw new InternalError("No such param: " + stringArray[i]);
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return (Box)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private class FourCcToBox {
        private String type;
        private byte[] userType;
        private String parent;
        private String clazzName;
        private String[] param;

        public FourCcToBox(String string, byte[] byArray, String string2) {
            this.type = string;
            this.parent = string2;
            this.userType = byArray;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String[] getParam() {
            return this.param;
        }

        public FourCcToBox invoke() {
            String string;
            if (this.userType != null) {
                if (!"uuid".equals(this.type)) {
                    throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
                }
                string = PropertyBoxParserImpl.this.mapping.getProperty(this.parent + "-uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty("uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                }
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty("uuid");
                }
            } else {
                string = PropertyBoxParserImpl.this.mapping.getProperty(this.parent + "-" + this.type);
                if (string == null) {
                    string = PropertyBoxParserImpl.this.mapping.getProperty(this.type);
                }
            }
            if (string == null) {
                string = PropertyBoxParserImpl.this.mapping.getProperty("default");
            }
            if (string == null) {
                throw new RuntimeException("No box object found for " + this.type);
            }
            if (!string.endsWith(")")) {
                this.clazzName = string;
                this.param = new String[0];
            } else {
                Matcher matcher = PropertyBoxParserImpl.this.constuctorPattern.matcher(string);
                boolean bl = matcher.matches();
                if (!bl) {
                    throw new RuntimeException("Cannot work with that constructor: " + string);
                }
                this.clazzName = matcher.group(1);
                this.param = matcher.group(2).length() > 0 ? matcher.group(2).split(",") : new String[]{};
            }
            return this;
        }
    }
}

