/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.CodecUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.packed.Direct16;
import org.apache.lucene.util.packed.Direct32;
import org.apache.lucene.util.packed.Direct64;
import org.apache.lucene.util.packed.Direct8;
import org.apache.lucene.util.packed.Packed32;
import org.apache.lucene.util.packed.Packed64;
import org.apache.lucene.util.packed.PackedWriter;

public class PackedInts {
    private static final String CODEC_NAME = "PackedInts";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    public static Reader getReader(DataInput dataInput) throws IOException {
        CodecUtil.checkHeader(dataInput, CODEC_NAME, 0, 0);
        int n = dataInput.readVInt();
        assert (n > 0 && n <= 64) : "bitsPerValue=" + n;
        int n2 = dataInput.readVInt();
        switch (n) {
            case 8: {
                return new Direct8(dataInput, n2);
            }
            case 16: {
                return new Direct16(dataInput, n2);
            }
            case 32: {
                return new Direct32(dataInput, n2);
            }
            case 64: {
                return new Direct64(dataInput, n2);
            }
        }
        if (Constants.JRE_IS_64BIT || n >= 32) {
            return new Packed64(dataInput, n2, n);
        }
        return new Packed32(dataInput, n2, n);
    }

    public static Mutable getMutable(int n, int n2) {
        switch (n2) {
            case 8: {
                return new Direct8(n);
            }
            case 16: {
                return new Direct16(n);
            }
            case 32: {
                return new Direct32(n);
            }
            case 64: {
                return new Direct64(n);
            }
        }
        if (Constants.JRE_IS_64BIT || n2 >= 32) {
            return new Packed64(n, n2);
        }
        return new Packed32(n, n2);
    }

    public static Writer getWriter(DataOutput dataOutput, int n, int n2) throws IOException {
        return new PackedWriter(dataOutput, n, n2);
    }

    public static int bitsRequired(long l) {
        if (l > 0x3FFFFFFFFFFFFFFFL) {
            return 63;
        }
        if (l > 0x1FFFFFFFFFFFFFFFL) {
            return 62;
        }
        return Math.max(1, (int)Math.ceil(Math.log(1L + l) / Math.log(2.0)));
    }

    public static long maxValue(int n) {
        return n == 64 ? Long.MAX_VALUE : -1L << n ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int getNextFixedSize(int n) {
        if (n <= 8) {
            return 8;
        }
        if (n <= 16) {
            return 16;
        }
        if (n <= 32) {
            return 32;
        }
        return 64;
    }

    public static int getRoundedFixedSize(int n) {
        if (n > 58 || n < 32 && n > 29) {
            return PackedInts.getNextFixedSize(n);
        }
        return n;
    }

    public static abstract class Writer {
        protected final DataOutput out;
        protected final int bitsPerValue;
        protected final int valueCount;

        protected Writer(DataOutput dataOutput, int n, int n2) throws IOException {
            assert (n2 <= 64);
            this.out = dataOutput;
            this.valueCount = n;
            this.bitsPerValue = n2;
            CodecUtil.writeHeader(dataOutput, PackedInts.CODEC_NAME, 0);
            dataOutput.writeVInt(n2);
            dataOutput.writeVInt(n);
        }

        public abstract void add(long var1) throws IOException;

        public abstract void finish() throws IOException;
    }

    public static abstract class ReaderImpl
    implements Reader {
        protected final int bitsPerValue;
        protected final int valueCount;

        protected ReaderImpl(int n, int n2) {
            this.bitsPerValue = n2;
            assert (n2 > 0 && n2 <= 64) : "bitsPerValue=" + n2;
            this.valueCount = n;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        public long getMaxValue() {
            return PackedInts.maxValue(this.bitsPerValue);
        }

        @Override
        public Object getArray() {
            return null;
        }

        @Override
        public boolean hasArray() {
            return false;
        }
    }

    public static interface Mutable
    extends Reader {
        public void set(int var1, long var2);

        public void clear();
    }

    public static interface Reader {
        public long get(int var1);

        public int getBitsPerValue();

        public int size();

        public Object getArray();

        public boolean hasArray();
    }
}

