/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;

public final class VirtualMethod<C> {
    private static final Set<Method> singletonSet = Collections.synchronizedSet(new HashSet());
    private final Class<C> baseClass;
    private final String method;
    private final Class<?>[] parameters;
    private final WeakHashMap<Class<? extends C>, Integer> cache = new WeakHashMap();

    public VirtualMethod(Class<C> clazz, String string, Class<?> ... classArray) {
        this.baseClass = clazz;
        this.method = string;
        this.parameters = classArray;
        try {
            if (!singletonSet.add(clazz.getDeclaredMethod(string, classArray))) {
                throw new UnsupportedOperationException("VirtualMethod instances must be singletons and therefore assigned to static final members in the same class, they use as baseClass ctor param.");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz.getName() + " has no such method: " + noSuchMethodException.getMessage());
        }
    }

    public synchronized int getImplementationDistance(Class<? extends C> clazz) {
        Integer n = this.cache.get(clazz);
        if (n == null) {
            n = this.reflectImplementationDistance(clazz);
            this.cache.put(clazz, n);
        }
        return n;
    }

    public boolean isOverriddenAsOf(Class<? extends C> clazz) {
        return this.getImplementationDistance(clazz) > 0;
    }

    private int reflectImplementationDistance(Class<? extends C> clazz) {
        if (!this.baseClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + this.baseClass.getName());
        }
        boolean bl = false;
        int n = 0;
        for (Class<C> clazz2 = clazz; clazz2 != this.baseClass && clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!bl) {
                try {
                    clazz2.getDeclaredMethod(this.method, this.parameters);
                    bl = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public static <C> int compareImplementationDistance(Class<? extends C> clazz, VirtualMethod<C> virtualMethod, VirtualMethod<C> virtualMethod2) {
        return Integer.valueOf(virtualMethod.getImplementationDistance(clazz)).compareTo(virtualMethod2.getImplementationDistance(clazz));
    }
}

