/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;

public final class UnicodeUtil {
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    private static final long UNI_MAX_BMP = 65535L;
    private static final int HALF_BASE = 65536;
    private static final long HALF_SHIFT = 10L;
    private static final long HALF_MASK = 1023L;
    private static final int SURROGATE_OFFSET = -56613888;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    private static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    private static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    private UnicodeUtil() {
    }

    public static int UTF16toUTF8WithHash(char[] cArray, int n, int n2, BytesRef bytesRef) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n + n2;
        byte[] byArray = bytesRef.bytes;
        int n7 = n2 * 4;
        if (byArray.length < n7) {
            byArray = bytesRef.bytes = new byte[ArrayUtil.oversize(n7, 1)];
        }
        bytesRef.offset = 0;
        while (n5 < n6) {
            int n8;
            char c;
            if ((c = cArray[n5++]) < '\u0080') {
                int n9 = n4++;
                byte by = (byte)c;
                byArray[n9] = by;
                n3 = 31 * n3 + by;
                continue;
            }
            if (c < '\u0800') {
                int n10 = n4++;
                byte by = (byte)(0xC0 | c >> 6);
                byArray[n10] = by;
                n3 = 31 * n3 + by;
                int n11 = n4++;
                byte by2 = (byte)(0x80 | c & 0x3F);
                byArray[n11] = by2;
                n3 = 31 * n3 + by2;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                int n12 = n4++;
                byte by = (byte)(0xE0 | c >> 12);
                byArray[n12] = by;
                n3 = 31 * n3 + by;
                int n13 = n4++;
                byte by3 = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n13] = by3;
                n3 = 31 * n3 + by3;
                int n14 = n4++;
                byte by4 = (byte)(0x80 | c & 0x3F);
                byArray[n14] = by4;
                n3 = 31 * n3 + by4;
                continue;
            }
            if (c < '\udc00' && n5 < n6 && (n8 = cArray[n5]) >= 56320 && n8 <= 57343) {
                n8 = (c << 10) + n8 + -56613888;
                ++n5;
                int n15 = n4++;
                byte by = (byte)(0xF0 | n8 >> 18);
                byArray[n15] = by;
                n3 = 31 * n3 + by;
                int n16 = n4++;
                byte by5 = (byte)(0x80 | n8 >> 12 & 0x3F);
                byArray[n16] = by5;
                n3 = 31 * n3 + by5;
                int n17 = n4++;
                byte by6 = (byte)(0x80 | n8 >> 6 & 0x3F);
                byArray[n17] = by6;
                n3 = 31 * n3 + by6;
                int n18 = n4++;
                byte by7 = (byte)(0x80 | n8 & 0x3F);
                byArray[n18] = by7;
                n3 = 31 * n3 + by7;
                continue;
            }
            byArray[n4++] = -17;
            n3 = 31 * n3 + -17;
            byArray[n4++] = -65;
            n3 = 31 * n3 + -65;
            byArray[n4++] = -67;
            n3 = 31 * n3 + -67;
        }
        bytesRef.length = n4;
        return n3;
    }

    public static void UTF16toUTF8(char[] cArray, int n, UTF8Result uTF8Result) {
        int n2 = 0;
        int n3 = n;
        byte[] byArray = uTF8Result.result;
        while (true) {
            int n4;
            char c = cArray[n3++];
            if (n2 + 4 > byArray.length) {
                byArray = uTF8Result.result = ArrayUtil.grow(byArray, n2 + 4);
            }
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2++] = (byte)(0xC0 | c >> 6);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                if (c == '\uffff') break;
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\udc00' && cArray[n3] != '\uffff' && (n4 = cArray[n3]) >= 56320 && n4 <= 57343) {
                n4 = (c - 55232 << 10) + (n4 & 0x3FF);
                ++n3;
                byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                byArray[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            byArray[n2++] = -17;
            byArray[n2++] = -65;
            byArray[n2++] = -67;
        }
        uTF8Result.length = n2;
    }

    public static void UTF16toUTF8(char[] cArray, int n, int n2, UTF8Result uTF8Result) {
        int n3 = 0;
        int n4 = n;
        int n5 = n + n2;
        byte[] byArray = uTF8Result.result;
        while (n4 < n5) {
            int n6;
            char c = cArray[n4++];
            if (n3 + 4 > byArray.length) {
                byArray = uTF8Result.result = ArrayUtil.grow(byArray, n3 + 4);
            }
            if (c < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\udc00' && n4 < n5 && cArray[n4] != '\uffff' && (n6 = cArray[n4]) >= 56320 && n6 <= 57343) {
                n6 = (c - 55232 << 10) + (n6 & 0x3FF);
                ++n4;
                byArray[n3++] = (byte)(0xF0 | n6 >> 18);
                byArray[n3++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            byArray[n3++] = -17;
            byArray[n3++] = -65;
            byArray[n3++] = -67;
        }
        uTF8Result.length = n3;
    }

    public static void UTF16toUTF8(String string, int n, int n2, UTF8Result uTF8Result) {
        int n3 = n + n2;
        byte[] byArray = uTF8Result.result;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            int n5;
            char c = string.charAt(i);
            if (n4 + 4 > byArray.length) {
                byArray = uTF8Result.result = ArrayUtil.grow(byArray, n4 + 4);
            }
            if (c < '\u0080') {
                byArray[n4++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n4++] = (byte)(0xC0 | c >> 6);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n4++] = (byte)(0xE0 | c >> 12);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\udc00' && i < n3 - 1 && (n5 = string.charAt(i + 1)) >= 56320 && n5 <= 57343) {
                n5 = (c - 55232 << 10) + (n5 & 0x3FF);
                ++i;
                byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            byArray[n4++] = -17;
            byArray[n4++] = -65;
            byArray[n4++] = -67;
        }
        uTF8Result.length = n4;
    }

    public static void UTF16toUTF8(CharSequence charSequence, int n, int n2, BytesRef bytesRef) {
        int n3 = n + n2;
        byte[] byArray = bytesRef.bytes;
        bytesRef.offset = 0;
        int n4 = n2 * 4;
        if (byArray.length < n4) {
            byArray = bytesRef.bytes = new byte[n4];
        }
        int n5 = 0;
        for (int i = n; i < n3; ++i) {
            int n6;
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                byArray[n5++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n5++] = (byte)(0xC0 | c >> 6);
                byArray[n5++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n5++] = (byte)(0xE0 | c >> 12);
                byArray[n5++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\udc00' && i < n3 - 1 && (n6 = charSequence.charAt(i + 1)) >= 56320 && n6 <= 57343) {
                n6 = (c << 10) + n6 + -56613888;
                ++i;
                byArray[n5++] = (byte)(0xF0 | n6 >> 18);
                byArray[n5++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            byArray[n5++] = -17;
            byArray[n5++] = -65;
            byArray[n5++] = -67;
        }
        bytesRef.length = n5;
    }

    public static void UTF16toUTF8(char[] cArray, int n, int n2, BytesRef bytesRef) {
        int n3 = 0;
        int n4 = n;
        int n5 = n + n2;
        byte[] byArray = bytesRef.bytes;
        int n6 = n2 * 4;
        if (byArray.length < n6) {
            byArray = bytesRef.bytes = new byte[n6];
        }
        bytesRef.offset = 0;
        while (n4 < n5) {
            int n7;
            char c;
            if ((c = cArray[n4++]) < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\udc00' && n4 < n5 && (n7 = cArray[n4]) >= 56320 && n7 <= 57343) {
                n7 = (c << 10) + n7 + -56613888;
                ++n4;
                byArray[n3++] = (byte)(0xF0 | n7 >> 18);
                byArray[n3++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n7 & 0x3F);
                continue;
            }
            byArray[n3++] = -17;
            byArray[n3++] = -65;
            byArray[n3++] = -67;
        }
        bytesRef.length = n3;
    }

    public static void UTF8toUTF16(byte[] byArray, int n, int n2, UTF16Result uTF16Result) {
        int n3 = n + n2;
        char[] cArray = uTF16Result.result;
        if (uTF16Result.offsets.length <= n3) {
            uTF16Result.offsets = ArrayUtil.grow(uTF16Result.offsets, n3 + 1);
        }
        int[] nArray = uTF16Result.offsets;
        int n4 = n;
        while (nArray[n4] == -1) {
            --n4;
        }
        int n5 = nArray[n4];
        if (n5 + n2 >= cArray.length) {
            cArray = uTF16Result.result = ArrayUtil.grow(cArray, n5 + n2 + 1);
        }
        while (n4 < n3) {
            int n6;
            int n7 = byArray[n4] & 0xFF;
            nArray[n4++] = n5;
            if (n7 < 192) {
                assert (n7 < 128);
                n6 = n7;
            } else if (n7 < 224) {
                n6 = ((n7 & 0x1F) << 6) + (byArray[n4] & 0x3F);
                nArray[n4++] = -1;
            } else if (n7 < 240) {
                n6 = ((n7 & 0xF) << 12) + ((byArray[n4] & 0x3F) << 6) + (byArray[n4 + 1] & 0x3F);
                nArray[n4++] = -1;
                nArray[n4++] = -1;
            } else {
                assert (n7 < 248);
                n6 = ((n7 & 7) << 18) + ((byArray[n4] & 0x3F) << 12) + ((byArray[n4 + 1] & 0x3F) << 6) + (byArray[n4 + 2] & 0x3F);
                nArray[n4++] = -1;
                nArray[n4++] = -1;
                nArray[n4++] = -1;
            }
            if ((long)n6 <= 65535L) {
                cArray[n5++] = (char)n6;
                continue;
            }
            int n8 = n6 - 65536;
            cArray[n5++] = (char)((n8 >> 10) + 55296);
            cArray[n5++] = (char)(((long)n8 & 0x3FFL) + 56320L);
        }
        nArray[n4] = n5;
        uTF16Result.length = n5;
    }

    public static String newString(int[] nArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n + n2;
        block2: for (int i = n; i < n4; ++i) {
            int n5 = nArray[i];
            if (n5 < 0 || n5 > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (n5 < 65536) {
                        cArray[n3] = (char)n5;
                        ++n3;
                        continue block2;
                    }
                    cArray[n3] = (char)(55232 + (n5 >> 10));
                    cArray[n3 + 1] = (char)(56320 + (n5 & 0x3FF));
                    n3 += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    int n6 = (int)Math.ceil((double)nArray.length * (double)(n3 + 2) / (double)(i - n + 1));
                    char[] cArray2 = new char[n6];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    cArray = cArray2;
                    continue;
                }
                break;
            }
        }
        return new String(cArray, 0, n3);
    }

    public static void UTF8toUTF16(byte[] byArray, int n, int n2, CharsRef charsRef) {
        charsRef.offset = 0;
        int n3 = 0;
        charsRef.chars = ArrayUtil.grow(charsRef.chars, n2);
        char[] cArray = charsRef.chars;
        int n4 = n + n2;
        while (n < n4) {
            int n5;
            if ((n5 = byArray[n++] & 0xFF) < 192) {
                assert (n5 < 128);
                cArray[n3++] = (char)n5;
                continue;
            }
            if (n5 < 224) {
                cArray[n3++] = (char)(((n5 & 0x1F) << 6) + (byArray[n++] & 0x3F));
                continue;
            }
            if (n5 < 240) {
                cArray[n3++] = (char)(((n5 & 0xF) << 12) + ((byArray[n] & 0x3F) << 6) + (byArray[n + 1] & 0x3F));
                n += 2;
                continue;
            }
            assert (n5 < 248);
            int n6 = ((n5 & 7) << 18) + ((byArray[n] & 0x3F) << 12) + ((byArray[n + 1] & 0x3F) << 6) + (byArray[n + 2] & 0x3F);
            n += 3;
            if ((long)n6 < 65535L) {
                cArray[n3++] = (char)n6;
                continue;
            }
            int n7 = n6 - 65536;
            cArray[n3++] = (char)((n7 >> 10) + 55296);
            cArray[n3++] = (char)(((long)n7 & 0x3FFL) + 56320L);
        }
        charsRef.length = n3 - charsRef.offset;
    }

    public static void UTF8toUTF16(BytesRef bytesRef, CharsRef charsRef) {
        UnicodeUtil.UTF8toUTF16(bytesRef.bytes, bytesRef.offset, bytesRef.length, charsRef);
    }

    public static final class UTF16Result {
        public char[] result = new char[10];
        public int[] offsets = new int[10];
        public int length;

        public void setLength(int n) {
            if (this.result.length < n) {
                this.result = ArrayUtil.grow(this.result, n);
            }
            this.length = n;
        }

        public void copyText(UTF16Result uTF16Result) {
            this.setLength(uTF16Result.length);
            System.arraycopy(uTF16Result.result, 0, this.result, 0, this.length);
        }
    }

    public static final class UTF8Result {
        public byte[] result = new byte[10];
        public int length;

        public void setLength(int n) {
            if (this.result.length < n) {
                this.result = ArrayUtil.grow(this.result, n);
            }
            this.length = n;
        }
    }
}

