/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class DoubleBarrelLRUCache<K extends CloneableKey, V> {
    private final Map<K, V> cache1;
    private final Map<K, V> cache2;
    private final AtomicInteger countdown;
    private volatile boolean swapped;
    private final int maxSize;

    public DoubleBarrelLRUCache(int n) {
        this.maxSize = n;
        this.countdown = new AtomicInteger(n);
        this.cache1 = new ConcurrentHashMap();
        this.cache2 = new ConcurrentHashMap();
    }

    public V get(K k) {
        Map<K, V> map;
        Map<K, V> map2;
        if (this.swapped) {
            map2 = this.cache2;
            map = this.cache1;
        } else {
            map2 = this.cache1;
            map = this.cache2;
        }
        V v = map2.get(k);
        if (v == null && (v = map.get(k)) != null) {
            this.put((CloneableKey)((CloneableKey)k).clone(), v);
        }
        return v;
    }

    public void put(K k, V v) {
        Map<K, V> map;
        Map<K, V> map2;
        if (this.swapped) {
            map2 = this.cache2;
            map = this.cache1;
        } else {
            map2 = this.cache1;
            map = this.cache2;
        }
        map2.put(k, v);
        if (this.countdown.decrementAndGet() == 0) {
            map.clear();
            this.swapped = !this.swapped;
            this.countdown.set(this.maxSize);
        }
    }

    public static abstract class CloneableKey {
        public abstract Object clone();
    }
}

