/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.SorterTemplate;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static <T> SorterTemplate getSorter(final List<T> list, final Comparator<? super T> comparator) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            @Override
            protected void swap(int n, int n2) {
                Collections.swap(list, n, n2);
            }

            @Override
            protected int compare(int n, int n2) {
                return comparator.compare(list.get(n), list.get(n2));
            }

            @Override
            protected void setPivot(int n) {
                this.pivot = list.get(n);
            }

            @Override
            protected int comparePivot(int n) {
                return comparator.compare(this.pivot, list.get(n));
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(final List<T> list) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            @Override
            protected void swap(int n, int n2) {
                Collections.swap(list, n, n2);
            }

            @Override
            protected int compare(int n, int n2) {
                return ((Comparable)list.get(n)).compareTo(list.get(n2));
            }

            @Override
            protected void setPivot(int n) {
                this.pivot = (Comparable)list.get(n);
            }

            @Override
            protected int comparePivot(int n) {
                return this.pivot.compareTo(list.get(n));
            }
        };
    }

    public static <T> void quickSort(List<T> list, Comparator<? super T> comparator) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comparator).quickSort(0, n - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(List<T> list) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).quickSort(0, n - 1);
    }

    public static <T> void mergeSort(List<T> list, Comparator<? super T> comparator) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comparator).mergeSort(0, n - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(List<T> list) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).mergeSort(0, n - 1);
    }

    public static <T> void insertionSort(List<T> list, Comparator<? super T> comparator) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list, comparator).insertionSort(0, n - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(List<T> list) {
        int n = list.size();
        if (n <= 1) {
            return;
        }
        CollectionUtil.getSorter(list).insertionSort(0, n - 1);
    }
}

