/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class AttributeSource {
    private final Map<Class<? extends Attribute>, AttributeImpl> attributes;
    private final Map<Class<? extends AttributeImpl>, AttributeImpl> attributeImpls;
    private final State[] currentState;
    private AttributeFactory factory;
    private static final WeakHashMap<Class<? extends AttributeImpl>, LinkedList<WeakReference<Class<? extends Attribute>>>> knownImplClasses = new WeakHashMap();

    public AttributeSource() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    public AttributeSource(AttributeSource attributeSource) {
        if (attributeSource == null) {
            throw new IllegalArgumentException("input AttributeSource must not be null");
        }
        this.attributes = attributeSource.attributes;
        this.attributeImpls = attributeSource.attributeImpls;
        this.currentState = attributeSource.currentState;
        this.factory = attributeSource.factory;
    }

    public AttributeSource(AttributeFactory attributeFactory) {
        this.attributes = new LinkedHashMap<Class<? extends Attribute>, AttributeImpl>();
        this.attributeImpls = new LinkedHashMap<Class<? extends AttributeImpl>, AttributeImpl>();
        this.currentState = new State[1];
        this.factory = attributeFactory;
    }

    public AttributeFactory getAttributeFactory() {
        return this.factory;
    }

    public Iterator<Class<? extends Attribute>> getAttributeClassesIterator() {
        return Collections.unmodifiableSet(this.attributes.keySet()).iterator();
    }

    public Iterator<AttributeImpl> getAttributeImplsIterator() {
        final State state = this.getCurrentState();
        if (state != null) {
            return new Iterator<AttributeImpl>(){
                private State state;
                {
                    this.state = state;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AttributeImpl next() {
                    if (this.state == null) {
                        throw new NoSuchElementException();
                    }
                    AttributeImpl attributeImpl = this.state.attribute;
                    this.state = this.state.next;
                    return attributeImpl;
                }

                @Override
                public boolean hasNext() {
                    return this.state != null;
                }
            };
        }
        return Collections.emptySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkedList<WeakReference<Class<? extends Attribute>>> getAttributeInterfaces(Class<? extends AttributeImpl> clazz) {
        WeakHashMap<Class<? extends AttributeImpl>, LinkedList<WeakReference<Class<? extends Attribute>>>> weakHashMap = knownImplClasses;
        synchronized (weakHashMap) {
            LinkedList<WeakReference<Class<Attribute>>> linkedList = knownImplClasses.get(clazz);
            if (linkedList == null) {
                linkedList = new LinkedList();
                knownImplClasses.put(clazz, linkedList);
                Class<? extends AttributeImpl> clazz2 = clazz;
                do {
                    for (Class<?> clazz3 : clazz2.getInterfaces()) {
                        if (clazz3 == Attribute.class || !Attribute.class.isAssignableFrom(clazz3)) continue;
                        linkedList.add(new WeakReference<Class<Attribute>>(clazz3.asSubclass(Attribute.class)));
                    }
                } while ((clazz2 = clazz2.getSuperclass()) != null);
            }
            return linkedList;
        }
    }

    public void addAttributeImpl(AttributeImpl attributeImpl) {
        Class<?> clazz = attributeImpl.getClass();
        if (this.attributeImpls.containsKey(clazz)) {
            return;
        }
        LinkedList<WeakReference<Class<? extends Attribute>>> linkedList = AttributeSource.getAttributeInterfaces(clazz);
        for (WeakReference weakReference : linkedList) {
            Class clazz2 = (Class)weakReference.get();
            assert (clazz2 != null) : "We have a strong reference on the class holding the interfaces, so they should never get evicted";
            if (this.attributes.containsKey(clazz2)) continue;
            this.currentState[0] = null;
            this.attributes.put(clazz2, attributeImpl);
            this.attributeImpls.put(clazz, attributeImpl);
        }
    }

    public <A extends Attribute> A addAttribute(Class<A> clazz) {
        AttributeImpl attributeImpl = this.attributes.get(clazz);
        if (attributeImpl == null) {
            if (!clazz.isInterface() || !Attribute.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("addAttribute() only accepts an interface that extends Attribute, but " + clazz.getName() + " does not fulfil this contract.");
            }
            attributeImpl = this.factory.createAttributeInstance(clazz);
            this.addAttributeImpl(attributeImpl);
        }
        return (A)((Attribute)clazz.cast(attributeImpl));
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasAttribute(Class<? extends Attribute> clazz) {
        return this.attributes.containsKey(clazz);
    }

    public <A extends Attribute> A getAttribute(Class<A> clazz) {
        AttributeImpl attributeImpl = this.attributes.get(clazz);
        if (attributeImpl == null) {
            throw new IllegalArgumentException("This AttributeSource does not have the attribute '" + clazz.getName() + "'.");
        }
        return (A)((Attribute)clazz.cast(attributeImpl));
    }

    private State getCurrentState() {
        State state = this.currentState[0];
        if (state != null || !this.hasAttributes()) {
            return state;
        }
        state = this.currentState[0] = new State();
        State state2 = this.currentState[0];
        Iterator<AttributeImpl> iterator = this.attributeImpls.values().iterator();
        state2.attribute = iterator.next();
        while (iterator.hasNext()) {
            state2 = state2.next = new State();
            state2.attribute = iterator.next();
        }
        return state;
    }

    public void clearAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.clear();
            state = state.next;
        }
    }

    public State captureState() {
        State state = this.getCurrentState();
        return state == null ? null : (State)state.clone();
    }

    public void restoreState(State state) {
        if (state == null) {
            return;
        }
        do {
            AttributeImpl attributeImpl;
            if ((attributeImpl = this.attributeImpls.get(state.attribute.getClass())) == null) {
                throw new IllegalArgumentException("State contains AttributeImpl of type " + state.attribute.getClass().getName() + " that is not in in this AttributeSource");
            }
            state.attribute.copyTo(attributeImpl);
        } while ((state = state.next) != null);
    }

    public int hashCode() {
        int n = 0;
        State state = this.getCurrentState();
        while (state != null) {
            n = n * 31 + state.attribute.hashCode();
            state = state.next;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AttributeSource) {
            AttributeSource attributeSource = (AttributeSource)object;
            if (this.hasAttributes()) {
                if (!attributeSource.hasAttributes()) {
                    return false;
                }
                if (this.attributeImpls.size() != attributeSource.attributeImpls.size()) {
                    return false;
                }
                State state = this.getCurrentState();
                State state2 = attributeSource.getCurrentState();
                while (state != null && state2 != null) {
                    if (state2.attribute.getClass() != state.attribute.getClass() || !state2.attribute.equals(state.attribute)) {
                        return false;
                    }
                    state = state.next;
                    state2 = state2.next;
                }
                return true;
            }
            return !attributeSource.hasAttributes();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append('(');
        if (this.hasAttributes()) {
            State state = this.getCurrentState();
            while (state != null) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(state.attribute.toString());
                state = state.next;
            }
        }
        return stringBuilder.append(')').toString();
    }

    public final String reflectAsString(final boolean bl) {
        final StringBuilder stringBuilder = new StringBuilder();
        this.reflectWith(new AttributeReflector(){

            @Override
            public void reflect(Class<? extends Attribute> clazz, String string, Object object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                if (bl) {
                    stringBuilder.append(clazz.getName()).append('#');
                }
                stringBuilder.append(string).append('=').append(object == null ? "null" : object);
            }
        });
        return stringBuilder.toString();
    }

    public final void reflectWith(AttributeReflector attributeReflector) {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.reflectWith(attributeReflector);
            state = state.next;
        }
    }

    public AttributeSource cloneAttributes() {
        AttributeSource attributeSource = new AttributeSource(this.factory);
        if (this.hasAttributes()) {
            Object object = this.getCurrentState();
            while (object != null) {
                attributeSource.attributeImpls.put(((State)object).attribute.getClass(), (AttributeImpl)((State)object).attribute.clone());
                object = ((State)object).next;
            }
            for (Map.Entry entry : this.attributes.entrySet()) {
                attributeSource.attributes.put((Class<? extends Attribute>)entry.getKey(), attributeSource.attributeImpls.get(((AttributeImpl)entry.getValue()).getClass()));
            }
        }
        return attributeSource;
    }

    public final void copyTo(AttributeSource attributeSource) {
        State state = this.getCurrentState();
        while (state != null) {
            AttributeImpl attributeImpl = attributeSource.attributeImpls.get(state.attribute.getClass());
            if (attributeImpl == null) {
                throw new IllegalArgumentException("This AttributeSource contains AttributeImpl of type " + state.attribute.getClass().getName() + " that is not in the target");
            }
            state.attribute.copyTo(attributeImpl);
            state = state.next;
        }
    }

    public static final class State
    implements Cloneable {
        AttributeImpl attribute;
        State next;

        public Object clone() {
            State state = new State();
            state.attribute = (AttributeImpl)this.attribute.clone();
            if (this.next != null) {
                state.next = (State)this.next.clone();
            }
            return state;
        }
    }

    public static abstract class AttributeFactory {
        public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

        public abstract AttributeImpl createAttributeInstance(Class<? extends Attribute> var1);

        private static final class DefaultAttributeFactory
        extends AttributeFactory {
            private static final WeakHashMap<Class<? extends Attribute>, WeakReference<Class<? extends AttributeImpl>>> attClassImplMap = new WeakHashMap();

            private DefaultAttributeFactory() {
            }

            @Override
            public AttributeImpl createAttributeInstance(Class<? extends Attribute> clazz) {
                try {
                    return DefaultAttributeFactory.getClassForInterface(clazz).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalArgumentException("Could not instantiate implementing class for " + clazz.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Could not instantiate implementing class for " + clazz.getName());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static Class<? extends AttributeImpl> getClassForInterface(Class<? extends Attribute> clazz) {
                WeakHashMap<Class<? extends Attribute>, WeakReference<Class<? extends AttributeImpl>>> weakHashMap = attClassImplMap;
                synchronized (weakHashMap) {
                    Class clazz2;
                    WeakReference<Class<? extends AttributeImpl>> weakReference = attClassImplMap.get(clazz);
                    Class<CharTermAttributeImpl> clazz3 = clazz2 = weakReference == null ? null : (Class<CharTermAttributeImpl>)weakReference.get();
                    if (clazz2 == null) {
                        try {
                            clazz2 = TermAttribute.class.equals(clazz) ? CharTermAttributeImpl.class : Class.forName(clazz.getName() + "Impl", true, clazz.getClassLoader()).asSubclass(AttributeImpl.class);
                            attClassImplMap.put(clazz, new WeakReference<Class<CharTermAttributeImpl>>(clazz2));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IllegalArgumentException("Could not find implementing class for " + clazz.getName());
                        }
                    }
                    return clazz2;
                }
            }
        }
    }
}

