/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class DataInput
implements Cloneable {
    private boolean preUTF8Strings;

    public void setModifiedUTF8StringsMode() {
        this.preUTF8Strings = true;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.readBytes(byArray, n, n2);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte by = this.readByte();
        int n = by & 0x7F;
        if ((by & 0x80) == 0) {
            return n;
        }
        by = this.readByte();
        n |= (by & 0x7F) << 7;
        if ((by & 0x80) == 0) {
            return n;
        }
        by = this.readByte();
        n |= (by & 0x7F) << 14;
        if ((by & 0x80) == 0) {
            return n;
        }
        by = this.readByte();
        n |= (by & 0x7F) << 21;
        if ((by & 0x80) == 0) {
            return n;
        }
        by = this.readByte();
        assert ((by & 0x80) == 0);
        return n | (by & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte by = this.readByte();
        long l = (long)by & 0x7FL;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 7;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 14;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 21;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 28;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 35;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 42;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        l |= ((long)by & 0x7FL) << 49;
        if ((by & 0x80) == 0) {
            return l;
        }
        by = this.readByte();
        assert ((by & 0x80) == 0);
        return l | ((long)by & 0x7FL) << 56;
    }

    public String readString() throws IOException {
        if (this.preUTF8Strings) {
            return this.readModifiedUTF8String();
        }
        int n = this.readVInt();
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return new String(byArray, 0, n, "UTF-8");
    }

    private String readModifiedUTF8String() throws IOException {
        int n = this.readVInt();
        char[] cArray = new char[n];
        this.readChars(cArray, 0, n);
        return new String(cArray, 0, n);
    }

    @Deprecated
    public void readChars(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byte by = this.readByte();
            cArray[i] = (by & 0x80) == 0 ? (char)(by & 0x7F) : ((by & 0xE0) != 224 ? (char)((by & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((by & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }

    public Object clone() {
        DataInput dataInput = null;
        try {
            dataInput = (DataInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return dataInput;
    }

    public Map<String, String> readStringStringMap() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            String string = this.readString();
            String string2 = this.readString();
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

