/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;

public class SpanWeight
extends Weight {
    protected Similarity similarity;
    protected float value;
    protected float idf;
    protected float queryNorm;
    protected float queryWeight;
    protected Set<Term> terms;
    protected SpanQuery query;
    private Explanation.IDFExplanation idfExp;

    public SpanWeight(SpanQuery spanQuery, Searcher searcher) throws IOException {
        this.similarity = spanQuery.getSimilarity(searcher);
        this.query = spanQuery;
        this.terms = new HashSet<Term>();
        spanQuery.extractTerms(this.terms);
        this.idfExp = this.similarity.idfExplain(this.terms, searcher);
        this.idf = this.idfExp.getIdf();
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float sumOfSquaredWeights() throws IOException {
        this.queryWeight = this.idf * this.query.getBoost();
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public void normalize(float f) {
        this.queryNorm = f;
        this.queryWeight *= f;
        this.value = this.queryWeight * this.idf;
    }

    @Override
    public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
        return new SpanScorer(this.query.getSpans(indexReader), this, this.similarity, indexReader.norms(this.query.getField()));
    }

    @Override
    public Explanation explain(IndexReader indexReader, int n) throws IOException {
        ComplexExplanation complexExplanation = new ComplexExplanation();
        complexExplanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
        String string = ((SpanQuery)this.getQuery()).getField();
        Explanation explanation = new Explanation(this.idf, "idf(" + string + ": " + this.idfExp.explain() + ")");
        Explanation explanation2 = new Explanation();
        explanation2.setDescription("queryWeight(" + this.getQuery() + "), product of:");
        Explanation explanation3 = new Explanation(this.getQuery().getBoost(), "boost");
        if (this.getQuery().getBoost() != 1.0f) {
            explanation2.addDetail(explanation3);
        }
        explanation2.addDetail(explanation);
        Explanation explanation4 = new Explanation(this.queryNorm, "queryNorm");
        explanation2.addDetail(explanation4);
        explanation2.setValue(explanation3.getValue() * explanation.getValue() * explanation4.getValue());
        complexExplanation.addDetail(explanation2);
        ComplexExplanation complexExplanation2 = new ComplexExplanation();
        complexExplanation2.setDescription("fieldWeight(" + string + ":" + this.query.toString(string) + " in " + n + "), product of:");
        Explanation explanation5 = ((SpanScorer)this.scorer(indexReader, true, false)).explain(n);
        complexExplanation2.addDetail(explanation5);
        complexExplanation2.addDetail(explanation);
        Explanation explanation6 = new Explanation();
        byte[] byArray = indexReader.norms(string);
        float f = byArray != null ? this.similarity.decodeNormValue(byArray[n]) : 1.0f;
        explanation6.setValue(f);
        explanation6.setDescription("fieldNorm(field=" + string + ", doc=" + n + ")");
        complexExplanation2.addDetail(explanation6);
        complexExplanation2.setMatch(explanation5.isMatch());
        complexExplanation2.setValue(explanation5.getValue() * explanation.getValue() * explanation6.getValue());
        complexExplanation.addDetail(complexExplanation2);
        complexExplanation.setMatch(complexExplanation2.getMatch());
        complexExplanation.setValue(explanation2.getValue() * complexExplanation2.getValue());
        if (explanation2.getValue() == 1.0f) {
            return complexExplanation2;
        }
        return complexExplanation;
    }
}

