/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.Spans;

public class SpanScorer
extends Scorer {
    protected Spans spans;
    protected byte[] norms;
    protected float value;
    protected boolean more = true;
    protected int doc;
    protected float freq;

    protected SpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] byArray) throws IOException {
        super(similarity, weight);
        this.spans = spans;
        this.norms = byArray;
        this.value = weight.getValue();
        if (this.spans.next()) {
            this.doc = -1;
        } else {
            this.doc = Integer.MAX_VALUE;
            this.more = false;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        if (!this.setFreqCurrentDoc()) {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public int advance(int n) throws IOException {
        if (!this.more) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (this.spans.doc() < n) {
            this.more = this.spans.skipTo(n);
        }
        if (!this.setFreqCurrentDoc()) {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    protected boolean setFreqCurrentDoc() throws IOException {
        if (!this.more) {
            return false;
        }
        this.doc = this.spans.doc();
        this.freq = 0.0f;
        do {
            int n = this.spans.end() - this.spans.start();
            this.freq += this.getSimilarity().sloppyFreq(n);
            this.more = this.spans.next();
        } while (this.more && this.doc == this.spans.doc());
        return true;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        float f = this.getSimilarity().tf(this.freq) * this.value;
        return this.norms == null ? f : f * this.getSimilarity().decodeNormValue(this.norms[this.doc]);
    }

    @Override
    public float freq() throws IOException {
        return this.freq;
    }

    protected Explanation explain(int n) throws IOException {
        Explanation explanation = new Explanation();
        int n2 = this.advance(n);
        float f = n2 == n ? this.freq : 0.0f;
        explanation.setValue(this.getSimilarity().tf(f));
        explanation.setDescription("tf(phraseFreq=" + f + ")");
        return explanation;
    }
}

