/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.NearSpansUnordered;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanNearQuery
extends SpanQuery
implements Cloneable {
    protected List<SpanQuery> clauses;
    protected int slop;
    protected boolean inOrder;
    protected String field;
    private boolean collectPayloads;

    public SpanNearQuery(SpanQuery[] spanQueryArray, int n, boolean bl) {
        this(spanQueryArray, n, bl, true);
    }

    public SpanNearQuery(SpanQuery[] spanQueryArray, int n, boolean bl, boolean bl2) {
        this.clauses = new ArrayList<SpanQuery>(spanQueryArray.length);
        for (int i = 0; i < spanQueryArray.length; ++i) {
            SpanQuery spanQuery = spanQueryArray[i];
            if (i == 0) {
                this.field = spanQuery.getField();
            } else if (!spanQuery.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(spanQuery);
        }
        this.collectPayloads = bl2;
        this.slop = n;
        this.inOrder = bl;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        for (SpanQuery spanQuery : this.clauses) {
            spanQuery.extractTerms(set);
        }
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanNear([");
        Iterator<SpanQuery> iterator = this.clauses.iterator();
        while (iterator.hasNext()) {
            SpanQuery spanQuery = iterator.next();
            stringBuilder.append(spanQuery.toString(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], ");
        stringBuilder.append(this.slop);
        stringBuilder.append(", ");
        stringBuilder.append(this.inOrder);
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Spans getSpans(IndexReader indexReader) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(indexReader);
        }
        if (this.clauses.size() == 1) {
            return this.clauses.get(0).getSpans(indexReader);
        }
        return this.inOrder ? new NearSpansOrdered(this, indexReader, this.collectPayloads) : new NearSpansUnordered(this, indexReader);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        SpanNearQuery spanNearQuery = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery spanQuery = this.clauses.get(i);
            SpanQuery spanQuery2 = (SpanQuery)spanQuery.rewrite(indexReader);
            if (spanQuery2 == spanQuery) continue;
            if (spanNearQuery == null) {
                spanNearQuery = (SpanNearQuery)this.clone();
            }
            spanNearQuery.clauses.set(i, spanQuery2);
        }
        if (spanNearQuery != null) {
            return spanNearQuery;
        }
        return this;
    }

    @Override
    public Object clone() {
        int n = this.clauses.size();
        SpanQuery[] spanQueryArray = new SpanQuery[n];
        for (int i = 0; i < n; ++i) {
            spanQueryArray[i] = (SpanQuery)this.clauses.get(i).clone();
        }
        SpanNearQuery spanNearQuery = new SpanNearQuery(spanQueryArray, this.slop, this.inOrder);
        spanNearQuery.setBoost(this.getBoost());
        return spanNearQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanNearQuery)) {
            return false;
        }
        SpanNearQuery spanNearQuery = (SpanNearQuery)object;
        if (this.inOrder != spanNearQuery.inOrder) {
            return false;
        }
        if (this.slop != spanNearQuery.slop) {
            return false;
        }
        if (!((Object)this.clauses).equals(spanNearQuery.clauses)) {
            return false;
        }
        return this.getBoost() == spanNearQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = ((Object)this.clauses).hashCode();
        n ^= n << 14 | n >>> 19;
        n += Float.floatToRawIntBits(this.getBoost());
        n += this.slop;
        return n ^= this.inOrder ? -1716530243 : 0;
    }
}

