/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.payloads.PayloadFunction;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.TermSpans;

public class PayloadTermQuery
extends SpanTermQuery {
    protected PayloadFunction function;
    private boolean includeSpanScore;

    public PayloadTermQuery(Term term, PayloadFunction payloadFunction) {
        this(term, payloadFunction, true);
    }

    public PayloadTermQuery(Term term, PayloadFunction payloadFunction, boolean bl) {
        super(term);
        this.function = payloadFunction;
        this.includeSpanScore = bl;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new PayloadTermWeight(this, searcher);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.function == null ? 0 : this.function.hashCode());
        n = 31 * n + (this.includeSpanScore ? 1231 : 1237);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PayloadTermQuery payloadTermQuery = (PayloadTermQuery)object;
        if (this.function == null ? payloadTermQuery.function != null : !this.function.equals(payloadTermQuery.function)) {
            return false;
        }
        return this.includeSpanScore == payloadTermQuery.includeSpanScore;
    }

    protected class PayloadTermWeight
    extends SpanWeight {
        public PayloadTermWeight(PayloadTermQuery payloadTermQuery2, Searcher searcher) throws IOException {
            super(payloadTermQuery2, searcher);
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            return new PayloadTermSpanScorer((TermSpans)this.query.getSpans(indexReader), this, this.similarity, indexReader.norms(this.query.getField()));
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            if (PayloadTermQuery.this.includeSpanScore) {
                return super.explain(indexReader, n);
            }
            PayloadTermSpanScorer payloadTermSpanScorer = (PayloadTermSpanScorer)this.scorer(indexReader, true, false);
            return payloadTermSpanScorer.explain(n);
        }

        protected class PayloadTermSpanScorer
        extends SpanScorer {
            protected byte[] payload;
            protected TermPositions positions;
            protected float payloadScore;
            protected int payloadsSeen;

            public PayloadTermSpanScorer(TermSpans termSpans, Weight weight, Similarity similarity, byte[] byArray) throws IOException {
                super(termSpans, weight, similarity, byArray);
                this.payload = new byte[256];
                this.positions = termSpans.getPositions();
            }

            @Override
            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int n = this.spans.end() - this.spans.start();
                    this.freq += similarity.sloppyFreq(n);
                    this.processPayload(similarity);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore = PayloadTermQuery.this.function.currentScore(this.doc, PayloadTermQuery.this.term.field(), this.spans.start(), this.spans.end(), this.payloadsSeen, this.payloadScore, similarity.scorePayload(this.doc, PayloadTermQuery.this.term.field(), this.spans.start(), this.spans.end(), this.payload, 0, this.positions.getPayloadLength()));
                    ++this.payloadsSeen;
                }
            }

            @Override
            public float score() throws IOException {
                return PayloadTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.score();
            }

            protected float getPayloadScore() {
                return PayloadTermQuery.this.function.docScore(this.doc, PayloadTermQuery.this.term.field(), this.payloadsSeen, this.payloadScore);
            }

            @Override
            protected Explanation explain(int n) throws IOException {
                Explanation explanation = super.explain(n);
                Explanation explanation2 = new Explanation();
                float f = this.getPayloadScore();
                explanation2.setValue(f);
                explanation2.setDescription("scorePayload(...)");
                ComplexExplanation complexExplanation = new ComplexExplanation();
                if (PayloadTermQuery.this.includeSpanScore) {
                    complexExplanation.addDetail(explanation);
                    complexExplanation.addDetail(explanation2);
                    complexExplanation.setValue(explanation.getValue() * f);
                    complexExplanation.setDescription("btq, product of:");
                } else {
                    complexExplanation.addDetail(explanation2);
                    complexExplanation.setValue(f);
                    complexExplanation.setDescription("btq(includeSpanScore=false), result of:");
                }
                complexExplanation.setMatch(explanation.getValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                return complexExplanation;
            }
        }
    }
}

