/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class PayloadSpanUtil {
    private IndexReader reader;

    public PayloadSpanUtil(IndexReader indexReader) {
        this.reader = indexReader;
    }

    public Collection<byte[]> getPayloadsForQuery(Query query) throws IOException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        this.queryToSpanQuery(query, arrayList);
        return arrayList;
    }

    private void queryToSpanQuery(Query query, Collection<byte[]> collection) throws IOException {
        if (query instanceof BooleanQuery) {
            BooleanClause[] booleanClauseArray = ((BooleanQuery)query).getClauses();
            for (int i = 0; i < booleanClauseArray.length; ++i) {
                if (booleanClauseArray[i].isProhibited()) continue;
                this.queryToSpanQuery(booleanClauseArray[i].getQuery(), collection);
            }
        } else if (query instanceof PhraseQuery) {
            int n;
            Term[] termArray = ((PhraseQuery)query).getTerms();
            SpanQuery[] spanQueryArray = new SpanQuery[termArray.length];
            for (n = 0; n < termArray.length; ++n) {
                spanQueryArray[n] = new SpanTermQuery(termArray[n]);
            }
            n = ((PhraseQuery)query).getSlop();
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            SpanNearQuery spanNearQuery = new SpanNearQuery(spanQueryArray, n, bl);
            spanNearQuery.setBoost(query.getBoost());
            this.getPayloads(collection, spanNearQuery);
        } else if (query instanceof TermQuery) {
            SpanTermQuery spanTermQuery = new SpanTermQuery(((TermQuery)query).getTerm());
            spanTermQuery.setBoost(query.getBoost());
            this.getPayloads(collection, spanTermQuery);
        } else if (query instanceof SpanQuery) {
            this.getPayloads(collection, (SpanQuery)query);
        } else if (query instanceof FilteredQuery) {
            this.queryToSpanQuery(((FilteredQuery)query).getQuery(), collection);
        } else if (query instanceof DisjunctionMaxQuery) {
            Iterator<Query> iterator = ((DisjunctionMaxQuery)query).iterator();
            while (iterator.hasNext()) {
                this.queryToSpanQuery(iterator.next(), collection);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery multiPhraseQuery = (MultiPhraseQuery)query;
            List<Term[]> list = multiPhraseQuery.getTermArrays();
            int[] nArray = multiPhraseQuery.getPositions();
            if (nArray.length > 0) {
                int n;
                Object object;
                int n2;
                int n3 = nArray[nArray.length - 1];
                for (int i = 0; i < nArray.length - 1; ++i) {
                    if (nArray[i] <= n3) continue;
                    n3 = nArray[i];
                }
                List[] listArray = new List[n3 + 1];
                int n4 = 0;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    Term[] termArray = list.get(n2);
                    object = listArray[nArray[n2]];
                    if (object == null) {
                        ArrayList arrayList = new ArrayList(termArray.length);
                        listArray[nArray[n2]] = arrayList;
                        object = arrayList;
                        ++n4;
                    }
                    for (Term term : termArray) {
                        object.add(new SpanTermQuery(term));
                    }
                }
                n2 = 0;
                int n5 = 0;
                object = new SpanQuery[n4];
                for (n = 0; n < listArray.length; ++n) {
                    List list2 = listArray[n];
                    if (list2 != null) {
                        object[n5++] = new SpanOrQuery(list2.toArray(new SpanQuery[list2.size()]));
                        continue;
                    }
                    ++n2;
                }
                n = multiPhraseQuery.getSlop();
                boolean bl = n == 0;
                SpanNearQuery spanNearQuery = new SpanNearQuery((SpanQuery[])object, n + n2, bl);
                spanNearQuery.setBoost(query.getBoost());
                this.getPayloads(collection, spanNearQuery);
            }
        }
    }

    private void getPayloads(Collection<byte[]> collection, SpanQuery spanQuery) throws IOException {
        Spans spans = spanQuery.getSpans(this.reader);
        while (spans.next()) {
            if (!spans.isPayloadAvailable()) continue;
            Collection<byte[]> collection2 = spans.getPayload();
            for (byte[] byArray : collection2) {
                collection.add(byArray);
            }
        }
    }
}

