/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class FloatFieldSource
extends FieldCacheSource {
    private FieldCache.FloatParser parser;

    public FloatFieldSource(String string) {
        this(string, null);
    }

    public FloatFieldSource(String string, FieldCache.FloatParser floatParser) {
        super(string);
        this.parser = floatParser;
    }

    @Override
    public String description() {
        return "float(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache fieldCache, String string, IndexReader indexReader) throws IOException {
        final float[] fArray = fieldCache.getFloats(indexReader, string, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int n) {
                return fArray[n];
            }

            @Override
            public String toString(int n) {
                return FloatFieldSource.this.description() + '=' + fArray[n];
            }

            @Override
            Object getInnerArray() {
                return fArray;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource fieldCacheSource) {
        if (fieldCacheSource.getClass() != FloatFieldSource.class) {
            return false;
        }
        FloatFieldSource floatFieldSource = (FloatFieldSource)fieldCacheSource;
        return this.parser == null ? floatFieldSource.parser == null : this.parser.getClass() == floatFieldSource.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Float.class.hashCode() : this.parser.getClass().hashCode();
    }
}

