/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    ScoreDoc pqTop = (ScoreDoc)this.pq.top();
    int docBase = 0;
    Scorer scorer;

    public static TopScoreDocCollector create(int n, boolean bl) {
        return TopScoreDocCollector.create(n, null, bl);
    }

    public static TopScoreDocCollector create(int n, ScoreDoc scoreDoc, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (bl) {
            return scoreDoc == null ? new InOrderTopScoreDocCollector(n) : new InOrderPagingScoreDocCollector(scoreDoc, n);
        }
        return scoreDoc == null ? new OutOfOrderTopScoreDocCollector(n) : new OutOfOrderPagingScoreDocCollector(scoreDoc, n);
    }

    private TopScoreDocCollector(int n) {
        super(new HitQueue(n, true));
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n) {
        if (scoreDocArray == null) {
            return EMPTY_TOPDOCS;
        }
        float f = Float.NaN;
        if (n == 0) {
            f = scoreDocArray[0].score;
        } else {
            for (int i = this.pq.size(); i > 1; --i) {
                this.pq.pop();
            }
            f = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, scoreDocArray, f);
    }

    @Override
    public void setNextReader(IndexReader indexReader, int n) {
        this.docBase = n;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    private static class OutOfOrderPagingScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int afterDoc;
        private int collectedHits;

        private OutOfOrderPagingScoreDocCollector(ScoreDoc scoreDoc, int n) {
            super(n);
            this.after = scoreDoc;
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            assert (!Float.isNaN(f));
            ++this.totalHits;
            if (f > this.after.score || f == this.after.score && n <= this.afterDoc) {
                return;
            }
            if (f < this.pqTop.score) {
                return;
            }
            if (f == this.pqTop.score && (n += this.docBase) > this.pqTop.doc) {
                return;
            }
            ++this.collectedHits;
            this.pqTop.doc = n;
            this.pqTop.score = f;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) {
            super.setNextReader(indexReader, n);
            this.afterDoc = this.after.doc - this.docBase;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n) {
            return scoreDocArray == null ? new TopDocs(this.totalHits, new ScoreDoc[0], Float.NaN) : new TopDocs(this.totalHits, scoreDocArray);
        }
    }

    private static class OutOfOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        private OutOfOrderTopScoreDocCollector(int n) {
            super(n);
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            assert (!Float.isNaN(f));
            ++this.totalHits;
            if (f < this.pqTop.score) {
                return;
            }
            if (f == this.pqTop.score && (n += this.docBase) > this.pqTop.doc) {
                return;
            }
            this.pqTop.doc = n;
            this.pqTop.score = f;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class InOrderPagingScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int afterDoc;
        private int collectedHits;

        private InOrderPagingScoreDocCollector(ScoreDoc scoreDoc, int n) {
            super(n);
            this.after = scoreDoc;
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            assert (f != Float.NEGATIVE_INFINITY);
            assert (!Float.isNaN(f));
            ++this.totalHits;
            if (f > this.after.score || f == this.after.score && n <= this.afterDoc) {
                return;
            }
            if (f <= this.pqTop.score) {
                return;
            }
            ++this.collectedHits;
            this.pqTop.doc = n + this.docBase;
            this.pqTop.score = f;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) {
            super.setNextReader(indexReader, n);
            this.afterDoc = this.after.doc - this.docBase;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n) {
            return scoreDocArray == null ? new TopDocs(this.totalHits, new ScoreDoc[0], Float.NaN) : new TopDocs(this.totalHits, scoreDocArray);
        }
    }

    private static class InOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        private InOrderTopScoreDocCollector(int n) {
            super(n);
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            assert (f != Float.NEGATIVE_INFINITY);
            assert (!Float.isNaN(f));
            ++this.totalHits;
            if (f <= this.pqTop.score) {
                return;
            }
            this.pqTop.doc = n + this.docBase;
            this.pqTop.score = f;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }
    }
}

