/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.TermRangeTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class TermRangeQuery
extends MultiTermQuery {
    private String lowerTerm;
    private String upperTerm;
    private Collator collator;
    private String field;
    private boolean includeLower;
    private boolean includeUpper;

    public TermRangeQuery(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(string, string2, string3, bl, bl2, null);
    }

    public TermRangeQuery(String string, String string2, String string3, boolean bl, boolean bl2, Collator collator) {
        this.field = string;
        this.lowerTerm = string2;
        this.upperTerm = string3;
        this.includeLower = bl;
        this.includeUpper = bl2;
        this.collator = collator;
    }

    public String getField() {
        return this.field;
    }

    public String getLowerTerm() {
        return this.lowerTerm;
    }

    public String getUpperTerm() {
        return this.upperTerm;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    public Collator getCollator() {
        return this.collator;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader indexReader) throws IOException {
        return new TermRangeTermEnum(indexReader, this.field, this.lowerTerm, this.upperTerm, this.includeLower, this.includeUpper, this.collator);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.getField().equals(string)) {
            stringBuilder.append(this.getField());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.includeLower ? (char)'[' : '{');
        stringBuilder.append(this.lowerTerm != null ? this.lowerTerm : "*");
        stringBuilder.append(" TO ");
        stringBuilder.append(this.upperTerm != null ? this.upperTerm : "*");
        stringBuilder.append(this.includeUpper ? (char)']' : '}');
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.collator == null ? 0 : this.collator.hashCode());
        n = 31 * n + (this.field == null ? 0 : this.field.hashCode());
        n = 31 * n + (this.includeLower ? 1231 : 1237);
        n = 31 * n + (this.includeUpper ? 1231 : 1237);
        n = 31 * n + (this.lowerTerm == null ? 0 : this.lowerTerm.hashCode());
        n = 31 * n + (this.upperTerm == null ? 0 : this.upperTerm.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TermRangeQuery termRangeQuery = (TermRangeQuery)object;
        if (this.collator == null ? termRangeQuery.collator != null : !this.collator.equals(termRangeQuery.collator)) {
            return false;
        }
        if (this.field == null ? termRangeQuery.field != null : !this.field.equals(termRangeQuery.field)) {
            return false;
        }
        if (this.includeLower != termRangeQuery.includeLower) {
            return false;
        }
        if (this.includeUpper != termRangeQuery.includeUpper) {
            return false;
        }
        if (this.lowerTerm == null ? termRangeQuery.lowerTerm != null : !this.lowerTerm.equals(termRangeQuery.lowerTerm)) {
            return false;
        }
        return !(this.upperTerm == null ? termRangeQuery.upperTerm != null : !this.upperTerm.equals(termRangeQuery.upperTerm));
    }
}

