/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Scorer;

class ReqOptSumScorer
extends Scorer {
    private Scorer reqScorer;
    private Scorer optScorer;

    public ReqOptSumScorer(Scorer scorer, Scorer scorer2) {
        super(scorer.weight);
        this.reqScorer = scorer;
        this.optScorer = scorer2;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.reqScorer.nextDoc();
    }

    @Override
    public int advance(int n) throws IOException {
        return this.reqScorer.advance(n);
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public float score() throws IOException {
        int n = this.reqScorer.docID();
        float f = this.reqScorer.score();
        if (this.optScorer == null) {
            return f;
        }
        int n2 = this.optScorer.docID();
        if (n2 < n && (n2 = this.optScorer.advance(n)) == Integer.MAX_VALUE) {
            this.optScorer = null;
            return f;
        }
        return n2 == n ? f + this.optScorer.score() : f;
    }
}

