/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public abstract class Query
implements Serializable,
Cloneable {
    private float boost = 1.0f;

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        throw new UnsupportedOperationException("Query " + this + " does not implement createWeight");
    }

    @Deprecated
    public final Weight weight(Searcher searcher) throws IOException {
        return searcher.createNormalizedWeight(this);
    }

    public Query rewrite(IndexReader indexReader) throws IOException {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Query combine(Query[] queryArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < queryArray.length; ++i) {
            Query query = queryArray[i];
            Object var5_7 = null;
            boolean bl = query instanceof BooleanQuery;
            if (bl) {
                BooleanQuery booleanQuery = (BooleanQuery)query;
                bl = booleanQuery.isCoordDisabled();
                BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
                for (int j = 0; bl && j < booleanClauseArray.length; ++j) {
                    bl = booleanClauseArray[j].getOccur() == BooleanClause.Occur.SHOULD;
                }
            }
            if (bl) {
                void booleanClauseArray;
                for (int j = 0; j < ((void)booleanClauseArray).length; ++j) {
                    hashSet.add(booleanClauseArray[j].getQuery());
                }
                continue;
            }
            hashSet.add(query);
        }
        if (hashSet.size() == 1) {
            return (Query)hashSet.iterator().next();
        }
        BooleanQuery booleanQuery = new BooleanQuery(true);
        for (Query query : hashSet) {
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    public void extractTerms(Set<Term> set) {
        throw new UnsupportedOperationException();
    }

    public static Query mergeBooleanQueries(BooleanQuery ... booleanQueryArray) {
        HashSet<BooleanClause> hashSet = new HashSet<BooleanClause>();
        for (BooleanQuery serializable : booleanQueryArray) {
            for (BooleanClause booleanClause : serializable) {
                hashSet.add(booleanClause);
            }
        }
        boolean bl = booleanQueryArray.length == 0 ? false : booleanQueryArray[0].isCoordDisabled();
        BooleanQuery booleanQuery = new BooleanQuery(bl);
        for (BooleanClause booleanClause : hashSet) {
            booleanQuery.add(booleanClause);
        }
        return booleanQuery;
    }

    @Deprecated
    public Similarity getSimilarity(Searcher searcher) {
        return searcher.getSimilarity();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported: " + cloneNotSupportedException.getMessage());
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.boost);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        return Float.floatToIntBits(this.boost) == Float.floatToIntBits(query.boost);
    }
}

