/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.search.NRTManager;
import org.apache.lucene.util.ThreadInterruptedException;

public class NRTManagerReopenThread
extends Thread
implements NRTManager.WaitingListener,
Closeable {
    private final NRTManager manager;
    private final long targetMaxStaleNS;
    private final long targetMinStaleNS;
    private boolean finish;
    private long waitingGen;
    private boolean waitingNeedsDeletes;

    public NRTManagerReopenThread(NRTManager nRTManager, double d, double d2) {
        if (d < d2) {
            throw new IllegalArgumentException("targetMaxScaleSec (= " + d + ") < targetMinStaleSec (=" + d2 + ")");
        }
        this.manager = nRTManager;
        this.targetMaxStaleNS = (long)(1.0E9 * d);
        this.targetMinStaleNS = (long)(1.0E9 * d2);
        nRTManager.addWaitingListener(this);
    }

    @Override
    public synchronized void close() {
        this.manager.removeWaitingListener(this);
        this.finish = true;
        this.notify();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException);
        }
    }

    @Override
    public synchronized void waiting(boolean bl, long l) {
        this.waitingNeedsDeletes |= bl;
        this.waitingGen = Math.max(this.waitingGen, l);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var1_1 = System.nanoTime();
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var3_2 = false;
                var4_4 = this;
                synchronized (var4_4) {
                    while (!this.finish && (var7_7 = (var5_6 = var1_1 + ((var3_2 = this.waitingGen > this.manager.getCurrentSearchingGen(this.waitingNeedsDeletes)) != false ? this.targetMinStaleNS : this.targetMaxStaleNS)) - System.nanoTime()) > 0L) {
                        try {
                            this.wait(var7_7 / 1000000L, (int)(var7_7 % 1000000L));
                        }
                        catch (InterruptedException var9_8) {
                            Thread.currentThread().interrupt();
                            this.finish = true;
                            break;
                        }
                    }
                    if (this.finish) {
                        return;
                    }
                }
                var1_1 = System.nanoTime();
                try {
                    this.manager.maybeReopen(this.waitingNeedsDeletes);
                    continue;
                }
                catch (IOException var4_5) {
                    throw new RuntimeException(var4_5);
                }
                break;
            }
        }
        catch (Throwable var3_3) {
            throw new RuntimeException(var3_3);
        }
        {
            ** while (true)
        }
    }
}

