/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;

public class MultiTermQueryWrapperFilter<Q extends MultiTermQuery>
extends Filter {
    protected final Q query;

    protected MultiTermQueryWrapperFilter(Q q) {
        this.query = q;
    }

    public String toString() {
        return ((Query)this.query).toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            return ((MultiTermQuery)this.query).equals(((MultiTermQueryWrapperFilter)object).query);
        }
        return false;
    }

    public final int hashCode() {
        return ((MultiTermQuery)this.query).hashCode();
    }

    @Deprecated
    public int getTotalNumberOfTerms() {
        return ((MultiTermQuery)this.query).getTotalNumberOfTerms();
    }

    @Deprecated
    public void clearTotalNumberOfTerms() {
        ((MultiTermQuery)this.query).clearTotalNumberOfTerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        FilteredTermEnum filteredTermEnum = ((MultiTermQuery)this.query).getEnum(indexReader);
        try {
            if (((TermEnum)filteredTermEnum).term() == null) {
                DocIdSet docIdSet = DocIdSet.EMPTY_DOCIDSET;
                return docIdSet;
            }
            FixedBitSet fixedBitSet = new FixedBitSet(indexReader.maxDoc());
            int[] nArray = new int[32];
            int[] nArray2 = new int[32];
            TermDocs termDocs = indexReader.termDocs();
            try {
                Term term;
                int n = 0;
                while ((term = ((TermEnum)filteredTermEnum).term()) != null) {
                    int n2;
                    ++n;
                    termDocs.seek(term);
                    while ((n2 = termDocs.read(nArray, nArray2)) != 0) {
                        for (int i = 0; i < n2; ++i) {
                            fixedBitSet.set(nArray[i]);
                        }
                    }
                    if (((TermEnum)filteredTermEnum).next()) continue;
                }
                ((MultiTermQuery)this.query).incTotalNumberOfTerms(n);
            }
            finally {
                termDocs.close();
            }
            FixedBitSet fixedBitSet2 = fixedBitSet;
            return fixedBitSet2;
        }
        finally {
            ((TermEnum)filteredTermEnum).close();
        }
    }
}

