/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class MultiCollector
extends Collector {
    private final Collector[] collectors;

    public static Collector wrap(Collector ... collectorArray) {
        Collector[] collectorArray2;
        int n = 0;
        for (Collector collector : collectorArray) {
            if (collector == null) continue;
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n == 1) {
            collectorArray2 = null;
            for (Collector collector : collectorArray) {
                if (collector == null) continue;
                collectorArray2 = collector;
                break;
            }
            return collectorArray2;
        }
        if (n == collectorArray.length) {
            return new MultiCollector(collectorArray);
        }
        collectorArray2 = new Collector[n];
        n = 0;
        for (Collector collector : collectorArray) {
            if (collector == null) continue;
            collectorArray2[n++] = collector;
        }
        return new MultiCollector(collectorArray2);
    }

    private MultiCollector(Collector ... collectorArray) {
        this.collectors = collectorArray;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        for (Collector collector : this.collectors) {
            if (collector.acceptsDocsOutOfOrder()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void collect(int n) throws IOException {
        for (Collector collector : this.collectors) {
            collector.collect(n);
        }
    }

    @Override
    public void setNextReader(IndexReader indexReader, int n) throws IOException {
        for (Collector collector : this.collectors) {
            collector.setNextReader(indexReader, n);
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        for (Collector collector : this.collectors) {
            collector.setScorer(scorer);
        }
    }
}

