/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.SingleTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    public static final int defaultPrefixLength = 0;
    public static final int defaultMaxExpansions = Integer.MAX_VALUE;
    private float minimumSimilarity;
    private int prefixLength;
    private boolean termLongEnough = false;
    protected Term term;

    public FuzzyQuery(Term term, float f, int n, int n2) {
        this.term = term;
        if (f >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity >= 1");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("maxExpansions < 0");
        }
        this.setRewriteMethod(new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(n2));
        if ((float)term.text().length() > 1.0f / (1.0f - f)) {
            this.termLongEnough = true;
        }
        this.minimumSimilarity = f;
        this.prefixLength = n;
    }

    public FuzzyQuery(Term term, float f, int n) {
        this(term, f, n, Integer.MAX_VALUE);
    }

    public FuzzyQuery(Term term, float f) {
        this(term, f, 0, Integer.MAX_VALUE);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0, Integer.MAX_VALUE);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader indexReader) throws IOException {
        if (!this.termLongEnough) {
            return new SingleTermEnum(indexReader, this.term);
        }
        return new FuzzyTermEnum(indexReader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append('~');
        stringBuilder.append(Float.toString(this.minimumSimilarity));
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Float.floatToIntBits(this.minimumSimilarity);
        n = 31 * n + this.prefixLength;
        n = 31 * n + (this.term == null ? 0 : this.term.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FuzzyQuery fuzzyQuery = (FuzzyQuery)object;
        if (Float.floatToIntBits(this.minimumSimilarity) != Float.floatToIntBits(fuzzyQuery.minimumSimilarity)) {
            return false;
        }
        if (this.prefixLength != fuzzyQuery.prefixLength) {
            return false;
        }
        return !(this.term == null ? fuzzyQuery.term != null : !this.term.equals(fuzzyQuery.term));
    }
}

