/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;

class FieldCacheImpl
implements FieldCache {
    private Map<Class<?>, Cache> caches;
    static final IndexReader.ReaderFinishedListener purgeReader = new IndexReader.ReaderFinishedListener(){

        @Override
        public void finished(IndexReader indexReader) {
            FieldCache.DEFAULT.purge(indexReader);
        }
    };
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(9);
        this.caches.put(Byte.TYPE, new ByteCache(this));
        this.caches.put(Short.TYPE, new ShortCache(this));
        this.caches.put(Integer.TYPE, new IntCache(this));
        this.caches.put(Float.TYPE, new FloatCache(this));
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(Double.TYPE, new DoubleCache(this));
        this.caches.put(String.class, new StringCache(this));
        this.caches.put(FieldCache.StringIndex.class, new StringIndexCache(this));
        this.caches.put(DocsWithFieldCache.class, new DocsWithFieldCache(this));
    }

    @Override
    public synchronized void purgeAllCaches() {
        this.init();
    }

    @Override
    public synchronized void purge(IndexReader indexReader) {
        for (Cache cache : this.caches.values()) {
            cache.purge(indexReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<CacheEntryImpl> arrayList = new ArrayList<CacheEntryImpl>(17);
        for (Map.Entry<Class<?>, Cache> entry : this.caches.entrySet()) {
            Cache cache = entry.getValue();
            Class<?> clazz = entry.getKey();
            Map<Object, Map<Entry, Object>> map = cache.readerCache;
            synchronized (map) {
                for (Map.Entry<Object, Map<Entry, Object>> entry2 : cache.readerCache.entrySet()) {
                    Object object = entry2.getKey();
                    if (object == null) continue;
                    Map<Entry, Object> map2 = entry2.getValue();
                    for (Map.Entry<Entry, Object> entry3 : map2.entrySet()) {
                        Entry entry4 = entry3.getKey();
                        arrayList.add(new CacheEntryImpl(object, entry4.field, clazz, entry4.custom, entry3.getValue()));
                    }
                }
            }
        }
        return arrayList.toArray(new FieldCache.CacheEntry[arrayList.size()]);
    }

    @Override
    public byte[] getBytes(IndexReader indexReader, String string) throws IOException {
        return this.getBytes(indexReader, string, null, false);
    }

    @Override
    public byte[] getBytes(IndexReader indexReader, String string, FieldCache.ByteParser byteParser) throws IOException {
        return this.getBytes(indexReader, string, byteParser, false);
    }

    @Override
    public byte[] getBytes(IndexReader indexReader, String string, FieldCache.ByteParser byteParser, boolean bl) throws IOException {
        return (byte[])this.caches.get(Byte.TYPE).get(indexReader, new Entry(string, byteParser), bl);
    }

    @Override
    public short[] getShorts(IndexReader indexReader, String string) throws IOException {
        return this.getShorts(indexReader, string, null, false);
    }

    @Override
    public short[] getShorts(IndexReader indexReader, String string, FieldCache.ShortParser shortParser) throws IOException {
        return this.getShorts(indexReader, string, shortParser, false);
    }

    @Override
    public short[] getShorts(IndexReader indexReader, String string, FieldCache.ShortParser shortParser, boolean bl) throws IOException {
        return (short[])this.caches.get(Short.TYPE).get(indexReader, new Entry(string, shortParser), bl);
    }

    void setDocsWithField(IndexReader indexReader, String string, Bits bits) {
        Bits bits2;
        int n = indexReader.maxDoc();
        if (bits == null) {
            bits2 = new Bits.MatchNoBits(n);
        } else if (bits instanceof FixedBitSet) {
            int n2 = ((FixedBitSet)bits).cardinality();
            if (n2 >= n) {
                assert (n2 == n);
                bits2 = new Bits.MatchAllBits(n);
            } else {
                bits2 = bits;
            }
        } else {
            bits2 = bits;
        }
        this.caches.get(DocsWithFieldCache.class).put(indexReader, new Entry(string, null), bits2);
    }

    @Override
    public int[] getInts(IndexReader indexReader, String string) throws IOException {
        return this.getInts(indexReader, string, null);
    }

    @Override
    public int[] getInts(IndexReader indexReader, String string, FieldCache.IntParser intParser) throws IOException {
        return this.getInts(indexReader, string, intParser, false);
    }

    @Override
    public int[] getInts(IndexReader indexReader, String string, FieldCache.IntParser intParser, boolean bl) throws IOException {
        return (int[])this.caches.get(Integer.TYPE).get(indexReader, new Entry(string, intParser), bl);
    }

    @Override
    public Bits getDocsWithField(IndexReader indexReader, String string) throws IOException {
        return (Bits)this.caches.get(DocsWithFieldCache.class).get(indexReader, new Entry(string, null), false);
    }

    @Override
    public float[] getFloats(IndexReader indexReader, String string) throws IOException {
        return this.getFloats(indexReader, string, null, false);
    }

    @Override
    public float[] getFloats(IndexReader indexReader, String string, FieldCache.FloatParser floatParser) throws IOException {
        return this.getFloats(indexReader, string, floatParser, false);
    }

    @Override
    public float[] getFloats(IndexReader indexReader, String string, FieldCache.FloatParser floatParser, boolean bl) throws IOException {
        return (float[])this.caches.get(Float.TYPE).get(indexReader, new Entry(string, floatParser), bl);
    }

    @Override
    public long[] getLongs(IndexReader indexReader, String string) throws IOException {
        return this.getLongs(indexReader, string, null, false);
    }

    @Override
    public long[] getLongs(IndexReader indexReader, String string, FieldCache.LongParser longParser) throws IOException {
        return this.getLongs(indexReader, string, longParser, false);
    }

    @Override
    public long[] getLongs(IndexReader indexReader, String string, FieldCache.LongParser longParser, boolean bl) throws IOException {
        return (long[])this.caches.get(Long.TYPE).get(indexReader, new Entry(string, longParser), bl);
    }

    @Override
    public double[] getDoubles(IndexReader indexReader, String string) throws IOException {
        return this.getDoubles(indexReader, string, null, false);
    }

    @Override
    public double[] getDoubles(IndexReader indexReader, String string, FieldCache.DoubleParser doubleParser) throws IOException {
        return this.getDoubles(indexReader, string, doubleParser, false);
    }

    @Override
    public double[] getDoubles(IndexReader indexReader, String string, FieldCache.DoubleParser doubleParser, boolean bl) throws IOException {
        return (double[])this.caches.get(Double.TYPE).get(indexReader, new Entry(string, doubleParser), bl);
    }

    @Override
    public String[] getStrings(IndexReader indexReader, String string) throws IOException {
        return (String[])this.caches.get(String.class).get(indexReader, new Entry(string, null), false);
    }

    @Override
    public FieldCache.StringIndex getStringIndex(IndexReader indexReader, String string) throws IOException {
        return (FieldCache.StringIndex)this.caches.get(FieldCache.StringIndex.class).get(indexReader, new Entry(string, null), false);
    }

    @Override
    public void setInfoStream(PrintStream printStream) {
        this.infoStream = printStream;
    }

    @Override
    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class StringIndexCache
    extends Cache {
        StringIndexCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Object object;
            String string = StringHelper.intern(entry.field);
            int[] nArray = new int[indexReader.maxDoc()];
            String[] stringArray = new String[indexReader.maxDoc() + 1];
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            int n = 0;
            stringArray[n++] = null;
            try {
                while ((object = termEnum.term()) != null && object.field() == string) {
                    if (n >= stringArray.length) {
                    } else {
                        stringArray[n] = object.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            nArray[termDocs.doc()] = n;
                        }
                        ++n;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (n == 0) {
                stringArray = new String[1];
            } else if (n < stringArray.length) {
                object = new String[n];
                System.arraycopy(stringArray, 0, object, 0, n);
                stringArray = object;
            }
            object = new FieldCache.StringIndex(nArray, stringArray);
            return object;
        }
    }

    static final class StringCache
    extends Cache {
        StringCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            String string = StringHelper.intern(entry.field);
            String[] stringArray = new String[indexReader.maxDoc()];
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            int n = indexReader.maxDoc();
            int n2 = 0;
            try {
                do {
                    if (n2++ == n) {
                        break;
                    }
                    Term term = termEnum.term();
                    if (term == null) break;
                    if (term.field() != string) {
                        break;
                    }
                    String string2 = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        stringArray[termDocs.doc()] = string2;
                    }
                } while (termEnum.next());
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return stringArray;
        }
    }

    static final class DoubleCache
    extends Cache {
        DoubleCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FieldCache.DoubleParser doubleParser = (FieldCache.DoubleParser)entry2.custom;
            if (doubleParser == null) {
                try {
                    return this.wrapper.getDoubles(indexReader, string, FieldCache.DEFAULT_DOUBLE_PARSER, bl);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.wrapper.getDoubles(indexReader, string, FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, bl);
                }
            }
            int n = indexReader.maxDoc();
            double[] dArray = null;
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        double d = doubleParser.parseDouble(term.text());
                        if (dArray == null) {
                            dArray = new double[n];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n2 = termDocs.doc();
                            dArray[n2] = d;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n2);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            if (dArray == null) {
                dArray = new double[n];
            }
            return dArray;
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            String string = entry.field;
            FieldCache.LongParser longParser = (FieldCache.LongParser)entry.custom;
            if (longParser == null) {
                try {
                    return this.wrapper.getLongs(indexReader, string, FieldCache.DEFAULT_LONG_PARSER, bl);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.wrapper.getLongs(indexReader, string, FieldCache.NUMERIC_UTILS_LONG_PARSER, bl);
                }
            }
            int n = indexReader.maxDoc();
            long[] lArray = null;
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        long l = longParser.parseLong(term.text());
                        if (lArray == null) {
                            lArray = new long[n];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n2 = termDocs.doc();
                            lArray[n2] = l;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n2);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            if (lArray == null) {
                lArray = new long[n];
            }
            return lArray;
        }
    }

    static final class FloatCache
    extends Cache {
        FloatCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FieldCache.FloatParser floatParser = (FieldCache.FloatParser)entry2.custom;
            if (floatParser == null) {
                try {
                    return this.wrapper.getFloats(indexReader, string, FieldCache.DEFAULT_FLOAT_PARSER, bl);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.wrapper.getFloats(indexReader, string, FieldCache.NUMERIC_UTILS_FLOAT_PARSER, bl);
                }
            }
            int n = indexReader.maxDoc();
            float[] fArray = null;
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        float f = floatParser.parseFloat(term.text());
                        if (fArray == null) {
                            fArray = new float[n];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n2 = termDocs.doc();
                            fArray[n2] = f;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n2);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            if (fArray == null) {
                fArray = new float[n];
            }
            return fArray;
        }
    }

    static final class DocsWithFieldCache
    extends Cache {
        DocsWithFieldCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FixedBitSet fixedBitSet = null;
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        if (fixedBitSet == null) {
                            fixedBitSet = new FixedBitSet(indexReader.maxDoc());
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            fixedBitSet.set(termDocs.doc());
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (fixedBitSet == null) {
                return new Bits.MatchNoBits(indexReader.maxDoc());
            }
            int n = fixedBitSet.cardinality();
            if (n >= indexReader.numDocs()) {
                assert (n == indexReader.numDocs());
                return new Bits.MatchAllBits(indexReader.maxDoc());
            }
            return fixedBitSet;
        }
    }

    static final class IntCache
    extends Cache {
        IntCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FieldCache.IntParser intParser = (FieldCache.IntParser)entry2.custom;
            if (intParser == null) {
                try {
                    return this.wrapper.getInts(indexReader, string, FieldCache.DEFAULT_INT_PARSER, bl);
                }
                catch (NumberFormatException numberFormatException) {
                    return this.wrapper.getInts(indexReader, string, FieldCache.NUMERIC_UTILS_INT_PARSER, bl);
                }
            }
            int n = indexReader.maxDoc();
            int[] nArray = null;
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        int n2 = intParser.parseInt(term.text());
                        if (nArray == null) {
                            nArray = new int[n];
                        }
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n3 = termDocs.doc();
                            nArray[n3] = n2;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n3);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            if (nArray == null) {
                nArray = new int[n];
            }
            return nArray;
        }
    }

    static final class ShortCache
    extends Cache {
        ShortCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FieldCache.ShortParser shortParser = (FieldCache.ShortParser)entry2.custom;
            if (shortParser == null) {
                return this.wrapper.getShorts(indexReader, string, FieldCache.DEFAULT_SHORT_PARSER, bl);
            }
            int n = indexReader.maxDoc();
            short[] sArray = new short[n];
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        short s = shortParser.parseShort(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n2 = termDocs.doc();
                            sArray[n2] = s;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n2);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            return sArray;
        }
    }

    static final class ByteCache
    extends Cache {
        ByteCache(FieldCacheImpl fieldCacheImpl) {
            super(fieldCacheImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createValue(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Entry entry2 = entry;
            String string = entry2.field;
            FieldCache.ByteParser byteParser = (FieldCache.ByteParser)entry2.custom;
            if (byteParser == null) {
                return this.wrapper.getBytes(indexReader, string, FieldCache.DEFAULT_BYTE_PARSER, bl);
            }
            int n = indexReader.maxDoc();
            byte[] byArray = new byte[n];
            TermDocs termDocs = indexReader.termDocs();
            TermEnum termEnum = indexReader.terms(new Term(string));
            FixedBitSet fixedBitSet = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != string) {
                    } else {
                        byte by = byteParser.parseByte(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int n2 = termDocs.doc();
                            byArray[n2] = by;
                            if (!bl) continue;
                            if (fixedBitSet == null) {
                                fixedBitSet = new FixedBitSet(n);
                            }
                            fixedBitSet.set(n2);
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (StopFillCacheException stopFillCacheException) {
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (bl) {
                this.wrapper.setDocsWithField(indexReader, string, fixedBitSet);
            }
            return byArray;
        }
    }

    static class Entry {
        final String field;
        final Object custom;

        Entry(String string, Object object) {
            this.field = StringHelper.intern(string);
            this.custom = object;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                if (entry.field == this.field && (entry.custom == null ? this.custom == null : entry.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCacheImpl wrapper;
        final Map<Object, Map<Entry, Object>> readerCache = new WeakHashMap<Object, Map<Entry, Object>>();

        Cache() {
            this.wrapper = null;
        }

        Cache(FieldCacheImpl fieldCacheImpl) {
            this.wrapper = fieldCacheImpl;
        }

        protected abstract Object createValue(IndexReader var1, Entry var2, boolean var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purge(IndexReader indexReader) {
            Object object = indexReader.getCoreCacheKey();
            Map<Object, Map<Entry, Object>> map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(IndexReader indexReader, Entry entry, Object object) {
            Object object2 = indexReader.getCoreCacheKey();
            Map<Object, Map<Entry, Object>> map = this.readerCache;
            synchronized (map) {
                Map<Entry, Object> map2 = this.readerCache.get(object2);
                if (map2 == null) {
                    map2 = new HashMap<Entry, Object>();
                    this.readerCache.put(object2, map2);
                    indexReader.addReaderFinishedListener(purgeReader);
                }
                if (map2.get(entry) == null) {
                    map2.put(entry, object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader indexReader, Entry entry, boolean bl) throws IOException {
            Object object;
            Map<Entry, Object> map;
            Object object2 = indexReader.getCoreCacheKey();
            Object object3 = this.readerCache;
            synchronized (object3) {
                map = this.readerCache.get(object2);
                if (map == null) {
                    map = new HashMap<Entry, Object>();
                    this.readerCache.put(object2, map);
                    indexReader.addReaderFinishedListener(purgeReader);
                    object = null;
                } else {
                    object = map.get(entry);
                }
                if (object == null) {
                    object = new FieldCache.CreationPlaceholder();
                    map.put(entry, object);
                }
            }
            if (object instanceof FieldCache.CreationPlaceholder) {
                object3 = object;
                synchronized (object3) {
                    FieldCache.CreationPlaceholder creationPlaceholder = (FieldCache.CreationPlaceholder)object;
                    if (creationPlaceholder.value == null) {
                        creationPlaceholder.value = this.createValue(indexReader, entry, bl);
                        Object object4 = this.readerCache;
                        synchronized (object4) {
                            map.put(entry, creationPlaceholder.value);
                        }
                        if (entry.custom != null && this.wrapper != null && (object4 = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity((PrintStream)object4, creationPlaceholder.value);
                        }
                    }
                    return creationPlaceholder.value;
                }
            }
            return object;
        }

        private void printNewInsanity(PrintStream printStream, Object object) {
            FieldCacheSanityChecker.Insanity[] insanityArray = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanityArray.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanityArray[i];
                FieldCache.CacheEntry[] cacheEntryArray = insanity.getCacheEntries();
                for (int j = 0; j < cacheEntryArray.length; ++j) {
                    if (cacheEntryArray[j].getValue() != object) continue;
                    printStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    printStream.println("\nStack:\n");
                    new Throwable().printStackTrace(printStream);
                    continue block0;
                }
            }
        }
    }

    static final class StopFillCacheException
    extends RuntimeException {
        StopFillCacheException() {
        }
    }

    private static final class CacheEntryImpl
    extends FieldCache.CacheEntry {
        private final Object readerKey;
        private final String fieldName;
        private final Class<?> cacheType;
        private final Object custom;
        private final Object value;

        CacheEntryImpl(Object object, String string, Class<?> clazz, Object object2, Object object3) {
            this.readerKey = object;
            this.fieldName = string;
            this.cacheType = clazz;
            this.custom = object2;
            this.value = object3;
        }

        @Override
        public Object getReaderKey() {
            return this.readerKey;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Class<?> getCacheType() {
            return this.cacheType;
        }

        @Override
        public Object getCustom() {
            return this.custom;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

