/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.messages;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NLS {
    private static Map<String, Class<? extends NLS>> bundles = new HashMap<String, Class<? extends NLS>>(0);

    protected NLS() {
    }

    public static String getLocalizedMessage(String string) {
        return NLS.getLocalizedMessage(string, Locale.getDefault());
    }

    public static String getLocalizedMessage(String string, Locale locale) {
        Object object = NLS.getResourceBundleObject(string, locale);
        if (object == null) {
            return "Message with key:" + string + " and locale: " + locale + " not found.";
        }
        return object.toString();
    }

    public static String getLocalizedMessage(String string, Locale locale, Object ... objectArray) {
        String string2 = NLS.getLocalizedMessage(string, locale);
        if (objectArray.length > 0) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public static String getLocalizedMessage(String string, Object ... objectArray) {
        return NLS.getLocalizedMessage(string, Locale.getDefault(), objectArray);
    }

    protected static void initializeMessages(String string, Class<? extends NLS> clazz) {
        try {
            NLS.load(clazz);
            if (!bundles.containsKey(string)) {
                bundles.put(string, clazz);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object getResourceBundleObject(String string, Locale locale) {
        Iterator<String> iterator = bundles.keySet().iterator();
        while (iterator.hasNext()) {
            Class<? extends NLS> clazz = bundles.get(iterator.next());
            ResourceBundle resourceBundle = ResourceBundle.getBundle(clazz.getName(), locale);
            if (resourceBundle == null) continue;
            try {
                Object object = resourceBundle.getObject(string);
                if (object == null) continue;
                return object;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    private static void load(Class<? extends NLS> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        boolean bl = (clazz.getModifiers() & 1) != 0;
        int n = fieldArray.length;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(n * 2);
        for (int i = 0; i < n; ++i) {
            hashMap.put(fieldArray[i].getName(), fieldArray[i]);
            NLS.loadfieldValue(fieldArray[i], bl, clazz);
        }
    }

    private static void loadfieldValue(Field field, boolean bl, Class<? extends NLS> clazz) {
        int n = 9;
        int n2 = n | 0x10;
        if ((field.getModifiers() & n2) != n) {
            return;
        }
        if (!bl) {
            NLS.makeAccessible(field);
        }
        try {
            field.set(null, field.getName());
            NLS.validateMessage(field.getName(), clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void validateMessage(String string, Class<? extends NLS> clazz) {
        try {
            Object object;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(clazz.getName(), Locale.getDefault());
            if (resourceBundle != null && (object = resourceBundle.getObject(string)) == null) {
                System.err.println("WARN: Message with key:" + string + " and locale: " + Locale.getDefault() + " not found.");
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("WARN: Message with key:" + string + " and locale: " + Locale.getDefault() + " not found.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }
}

