/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.Constants;

public class UpgradeIndexMergePolicy
extends MergePolicy {
    protected final MergePolicy base;

    public UpgradeIndexMergePolicy(MergePolicy mergePolicy) {
        this.base = mergePolicy;
    }

    protected boolean shouldUpgradeSegment(SegmentInfo segmentInfo) {
        return !Constants.LUCENE_MAIN_VERSION.equals(segmentInfo.getVersion());
    }

    @Override
    public void setIndexWriter(IndexWriter indexWriter) {
        super.setIndexWriter(indexWriter);
        this.base.setIndexWriter(indexWriter);
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        return this.base.findMerges(segmentInfos);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int n, Map<SegmentInfo, Boolean> map) throws CorruptIndexException, IOException {
        HashMap<SegmentInfo, Boolean> hashMap = new HashMap<SegmentInfo, Boolean>();
        for (Cloneable cloneable : segmentInfos) {
            Boolean object2 = map.get(cloneable);
            if (object2 == null || !this.shouldUpgradeSegment((SegmentInfo)cloneable)) continue;
            hashMap.put((SegmentInfo)cloneable, object2);
        }
        if (this.verbose()) {
            this.message("findForcedMerges: segmentsToUpgrade=" + hashMap);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        Object object = this.base.findForcedMerges(segmentInfos, n, hashMap);
        if (object != null) {
            for (MergePolicy.OneMerge oneMerge : ((MergePolicy.MergeSpecification)object).merges) {
                hashMap.keySet().removeAll(oneMerge.segments);
            }
        }
        if (!hashMap.isEmpty()) {
            Cloneable cloneable;
            if (this.verbose()) {
                this.message("findForcedMerges: " + this.base.getClass().getSimpleName() + " does not want to merge all old segments, merge remaining ones into new segment: " + hashMap);
            }
            cloneable = new ArrayList<SegmentInfo>();
            for (SegmentInfo segmentInfo : segmentInfos) {
                if (!hashMap.containsKey(segmentInfo)) continue;
                cloneable.add(segmentInfo);
            }
            if (object == null) {
                object = new MergePolicy.MergeSpecification();
            }
            ((MergePolicy.MergeSpecification)object).add(new MergePolicy.OneMerge((List<SegmentInfo>)((Object)cloneable)));
        }
        return object;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        return this.base.findForcedDeletesMerges(segmentInfos);
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segmentInfos, SegmentInfo segmentInfo) throws IOException {
        return this.base.useCompoundFile(segmentInfos, segmentInfo);
    }

    @Override
    public void close() {
        this.base.close();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "->" + this.base + "]";
    }

    private boolean verbose() {
        IndexWriter indexWriter = (IndexWriter)this.writer.get();
        return indexWriter != null && indexWriter.verbose();
    }

    private void message(String string) {
        if (this.verbose()) {
            ((IndexWriter)this.writer.get()).message("UPGMP: " + string);
        }
    }
}

