/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.IndexInput;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private IndexInput proxStream = null;
    private int proxCount;
    private int position;
    private int payloadLength;
    private boolean needToLoadPayload;
    private long lazySkipPointer = -1L;
    private int lazySkipProxCount = 0;

    SegmentTermPositions(SegmentReader segmentReader) {
        super(segmentReader);
    }

    @Override
    final void seek(TermInfo termInfo, Term term) throws IOException {
        super.seek(termInfo, term);
        if (termInfo != null) {
            this.lazySkipPointer = termInfo.proxPointer;
        }
        this.lazySkipProxCount = 0;
        this.proxCount = 0;
        this.payloadLength = 0;
        this.needToLoadPayload = false;
    }

    @Override
    public final void close() throws IOException {
        super.close();
        if (this.proxStream != null) {
            this.proxStream.close();
        }
    }

    @Override
    public final int nextPosition() throws IOException {
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            return 0;
        }
        this.lazySkip();
        --this.proxCount;
        return this.position += this.readDeltaPosition();
    }

    private final int readDeltaPosition() throws IOException {
        int n = this.proxStream.readVInt();
        if (this.currentFieldStoresPayloads) {
            if ((n & 1) != 0) {
                this.payloadLength = this.proxStream.readVInt();
            }
            n >>>= 1;
            this.needToLoadPayload = true;
        }
        return n;
    }

    @Override
    protected final void skippingDoc() throws IOException {
        this.lazySkipProxCount += this.freq;
    }

    @Override
    public final boolean next() throws IOException {
        this.lazySkipProxCount += this.proxCount;
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    @Override
    public final int read(int[] nArray, int[] nArray2) {
        throw new UnsupportedOperationException("TermPositions does not support processing multiple documents in one call. Use TermDocs instead.");
    }

    @Override
    protected void skipProx(long l, int n) throws IOException {
        this.lazySkipPointer = l;
        this.lazySkipProxCount = 0;
        this.proxCount = 0;
        this.payloadLength = n;
        this.needToLoadPayload = false;
    }

    private void skipPositions(int n) throws IOException {
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        for (int i = n; i > 0; --i) {
            this.readDeltaPosition();
            this.skipPayload();
        }
    }

    private void skipPayload() throws IOException {
        if (this.needToLoadPayload && this.payloadLength > 0) {
            this.proxStream.seek(this.proxStream.getFilePointer() + (long)this.payloadLength);
        }
        this.needToLoadPayload = false;
    }

    private void lazySkip() throws IOException {
        if (this.proxStream == null) {
            this.proxStream = (IndexInput)this.parent.core.proxStream.clone();
        }
        this.skipPayload();
        if (this.lazySkipPointer != -1L) {
            this.proxStream.seek(this.lazySkipPointer);
            this.lazySkipPointer = -1L;
        }
        if (this.lazySkipProxCount != 0) {
            this.skipPositions(this.lazySkipProxCount);
            this.lazySkipProxCount = 0;
        }
    }

    @Override
    public int getPayloadLength() {
        return this.payloadLength;
    }

    @Override
    public byte[] getPayload(byte[] byArray, int n) throws IOException {
        int n2;
        byte[] byArray2;
        if (!this.needToLoadPayload) {
            throw new IOException("Either no payload exists at this term position or an attempt was made to load it more than once.");
        }
        if (byArray == null || byArray.length - n < this.payloadLength) {
            byArray2 = new byte[this.payloadLength];
            n2 = 0;
        } else {
            byArray2 = byArray;
            n2 = n;
        }
        this.proxStream.readBytes(byArray2, n2, this.payloadLength);
        this.needToLoadPayload = false;
        return byArray2;
    }

    @Override
    public boolean isPayloadAvailable() {
        return this.needToLoadPayload && this.payloadLength > 0;
    }
}

