/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentNorms
implements Cloneable {
    static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    int refCount = 1;
    private SegmentNorms origNorm;
    private IndexInput in;
    private long normSeek;
    private AtomicInteger bytesRef;
    private byte[] bytes;
    private int number;
    boolean dirty;
    boolean rollbackDirty;
    private final SegmentReader owner;

    public SegmentNorms(IndexInput indexInput, int n, long l, SegmentReader segmentReader) {
        this.in = indexInput;
        this.number = n;
        this.normSeek = l;
        this.owner = segmentReader;
    }

    public synchronized void incRef() {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        ++this.refCount;
    }

    private void closeInput() throws IOException {
        if (this.in != null) {
            if (this.in != this.owner.singleNormStream) {
                this.in.close();
            } else if (this.owner.singleNormRef.decrementAndGet() == 0) {
                this.owner.singleNormStream.close();
                this.owner.singleNormStream = null;
            }
            this.in = null;
        }
    }

    public synchronized void decRef() throws IOException {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        if (--this.refCount == 0) {
            if (this.origNorm != null) {
                this.origNorm.decRef();
                this.origNorm = null;
            } else {
                this.closeInput();
            }
            if (this.bytes != null) {
                assert (this.bytesRef != null);
                this.bytesRef.decrementAndGet();
                this.bytes = null;
                this.bytesRef = null;
            } else assert (this.bytesRef == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void bytes(byte[] byArray, int n, int n2) throws IOException {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        if (this.bytes != null) {
            assert (n2 <= this.owner.maxDoc());
            System.arraycopy(this.bytes, 0, byArray, n, n2);
        } else if (this.origNorm != null) {
            this.origNorm.bytes(byArray, n, n2);
        } else {
            IndexInput indexInput = this.in;
            synchronized (indexInput) {
                this.in.seek(this.normSeek);
                this.in.readBytes(byArray, n, n2, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] bytes() throws IOException {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        if (this.bytes == null) {
            assert (this.bytesRef == null);
            if (this.origNorm != null) {
                this.bytes = this.origNorm.bytes();
                this.bytesRef = this.origNorm.bytesRef;
                this.bytesRef.incrementAndGet();
                this.origNorm.decRef();
                this.origNorm = null;
            } else {
                int n = this.owner.maxDoc();
                this.bytes = new byte[n];
                assert (this.in != null);
                IndexInput indexInput = this.in;
                synchronized (indexInput) {
                    this.in.seek(this.normSeek);
                    this.in.readBytes(this.bytes, 0, n, false);
                }
                this.bytesRef = new AtomicInteger(1);
                this.closeInput();
            }
        }
        return this.bytes;
    }

    AtomicInteger bytesRef() {
        return this.bytesRef;
    }

    public synchronized byte[] copyOnWrite() throws IOException {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        this.bytes();
        assert (this.bytes != null);
        assert (this.bytesRef != null);
        if (this.bytesRef.get() > 1) {
            assert (this.refCount == 1);
            AtomicInteger atomicInteger = this.bytesRef;
            this.bytes = this.owner.cloneNormBytes(this.bytes);
            this.bytesRef = new AtomicInteger(1);
            atomicInteger.decrementAndGet();
        }
        this.dirty = true;
        return this.bytes;
    }

    public synchronized Object clone() {
        SegmentNorms segmentNorms;
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0));
        try {
            segmentNorms = (SegmentNorms)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("unexpected CloneNotSupportedException", cloneNotSupportedException);
        }
        segmentNorms.refCount = 1;
        if (this.bytes != null) {
            assert (this.bytesRef != null);
            assert (this.origNorm == null);
            segmentNorms.bytesRef.incrementAndGet();
        } else {
            assert (this.bytesRef == null);
            if (this.origNorm == null) {
                segmentNorms.origNorm = this;
            }
            segmentNorms.origNorm.incRef();
        }
        segmentNorms.in = null;
        return segmentNorms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reWrite(SegmentInfo segmentInfo) throws IOException {
        assert (this.refCount > 0 && (this.origNorm == null || this.origNorm.refCount > 0)) : "refCount=" + this.refCount + " origNorm=" + this.origNorm;
        segmentInfo.advanceNormGen(this.number);
        String string = segmentInfo.getNormFileName(this.number);
        IndexOutput indexOutput = this.owner.directory().createOutput(string);
        boolean bl = false;
        try {
            try {
                indexOutput.writeBytes(NORMS_HEADER, 0, NORMS_HEADER.length);
                indexOutput.writeBytes(this.bytes, this.owner.maxDoc());
            }
            finally {
                indexOutput.close();
            }
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.owner.directory().deleteFile(string);
                }
                catch (Throwable throwable) {}
            }
        }
        this.dirty = false;
    }
}

