/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;

abstract class MultiLevelSkipListWriter {
    private int numberOfSkipLevels;
    private int skipInterval;
    private RAMOutputStream[] skipBuffer;

    protected MultiLevelSkipListWriter(int n, int n2, int n3) {
        this.skipInterval = n;
        int n4 = this.numberOfSkipLevels = n3 == 0 ? 0 : (int)Math.floor(Math.log(n3) / Math.log(n));
        if (this.numberOfSkipLevels > n2) {
            this.numberOfSkipLevels = n2;
        }
    }

    protected void init() {
        this.skipBuffer = new RAMOutputStream[this.numberOfSkipLevels];
        for (int i = 0; i < this.numberOfSkipLevels; ++i) {
            this.skipBuffer[i] = new RAMOutputStream();
        }
    }

    protected void resetSkip() {
        if (this.skipBuffer == null) {
            this.init();
        } else {
            for (int i = 0; i < this.skipBuffer.length; ++i) {
                this.skipBuffer[i].reset();
            }
        }
    }

    protected abstract void writeSkipData(int var1, IndexOutput var2) throws IOException;

    void bufferSkip(int n) throws IOException {
        int n2 = 0;
        while (n % this.skipInterval == 0 && n2 < this.numberOfSkipLevels) {
            ++n2;
            n /= this.skipInterval;
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            this.writeSkipData(i, this.skipBuffer[i]);
            long l2 = this.skipBuffer[i].getFilePointer();
            if (i != 0) {
                this.skipBuffer[i].writeVLong(l);
            }
            l = l2;
        }
    }

    long writeSkip(IndexOutput indexOutput) throws IOException {
        long l = indexOutput.getFilePointer();
        if (this.skipBuffer == null || this.skipBuffer.length == 0) {
            return l;
        }
        for (int i = this.numberOfSkipLevels - 1; i > 0; --i) {
            long l2 = this.skipBuffer[i].getFilePointer();
            if (l2 <= 0L) continue;
            indexOutput.writeVLong(l2);
            this.skipBuffer[i].writeTo(indexOutput);
        }
        this.skipBuffer[0].writeTo(indexOutput);
        return l;
    }
}

