/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SetOnce;

public abstract class MergePolicy
implements Closeable {
    protected final SetOnce<IndexWriter> writer = new SetOnce();

    public void setIndexWriter(IndexWriter indexWriter) {
        this.writer.set(indexWriter);
    }

    public abstract MergeSpecification findMerges(SegmentInfos var1) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentInfo, Boolean> var3) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findForcedDeletesMerges(SegmentInfos var1) throws CorruptIndexException, IOException;

    @Override
    public abstract void close();

    public abstract boolean useCompoundFile(SegmentInfos var1, SegmentInfo var2) throws IOException;

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String string) {
            super(string);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String string, Directory directory) {
            super(string);
            this.dir = directory;
        }

        public MergeException(Throwable throwable, Directory directory) {
            super(throwable);
            this.dir = directory;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge oneMerge) {
            this.merges.add(oneMerge);
        }

        public String segString(Directory directory) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MergeSpec:\n");
            int n = this.merges.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString(directory));
            }
            return stringBuilder.toString();
        }
    }

    public static class OneMerge {
        SegmentInfo info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public long estimatedMergeBytes;
        List<SegmentReader> readers;
        List<SegmentReader> readerClones;
        public final List<SegmentInfo> segments;
        public final int totalDocCount;
        boolean aborted;
        Throwable error;
        boolean paused;

        public OneMerge(List<SegmentInfo> list) {
            if (0 == list.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentInfo>(list);
            int n = 0;
            for (SegmentInfo segmentInfo : list) {
                n += segmentInfo.docCount;
            }
            this.totalDocCount = n;
        }

        synchronized void setException(Throwable throwable) {
            this.error = throwable;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        synchronized void abort() {
            this.aborted = true;
            this.notifyAll();
        }

        synchronized boolean isAborted() {
            return this.aborted;
        }

        synchronized void checkAborted(Directory directory) throws MergeAbortedException {
            if (this.aborted) {
                throw new MergeAbortedException("merge is aborted: " + this.segString(directory));
            }
            while (this.paused) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (!this.aborted) continue;
                throw new MergeAbortedException("merge is aborted: " + this.segString(directory));
            }
        }

        public synchronized void setPause(boolean bl) {
            this.paused = bl;
            if (!bl) {
                this.notifyAll();
            }
        }

        public synchronized boolean getPause() {
            return this.paused;
        }

        public String segString(Directory directory) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.segments.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.segments.get(i).toString(directory, 0));
            }
            if (this.info != null) {
                stringBuilder.append(" into ").append(this.info.name);
            }
            if (this.maxNumSegments != -1) {
                stringBuilder.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.aborted) {
                stringBuilder.append(" [ABORTED]");
            }
            return stringBuilder.toString();
        }

        public long totalBytesSize() throws IOException {
            long l = 0L;
            for (SegmentInfo segmentInfo : this.segments) {
                l += segmentInfo.sizeInBytes(true);
            }
            return l;
        }

        public int totalNumDocs() throws IOException {
            int n = 0;
            for (SegmentInfo segmentInfo : this.segments) {
                n += segmentInfo.docCount;
            }
            return n;
        }
    }
}

