/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.util.CollectionUtil;

final class IndexFileDeleter {
    private List<String> deletable;
    private Map<String, RefCount> refCounts = new HashMap<String, RefCount>();
    private List<CommitPoint> commits = new ArrayList<CommitPoint>();
    private List<Collection<String>> lastFiles = new ArrayList<Collection<String>>();
    private List<CommitPoint> commitsToDelete = new ArrayList<CommitPoint>();
    private PrintStream infoStream;
    private Directory directory;
    private IndexDeletionPolicy policy;
    final boolean startingCommitDeleted;
    private SegmentInfos lastSegmentInfos;
    public static boolean VERBOSE_REF_COUNTS = false;
    private final IndexWriter writer;

    void setInfoStream(PrintStream printStream) {
        this.infoStream = printStream;
        if (printStream != null) {
            this.message("setInfoStream deletionPolicy=" + this.policy);
        }
    }

    private void message(String string) {
        this.infoStream.println("IFD [" + new Date() + "; " + Thread.currentThread().getName() + "]: " + string);
    }

    private boolean locked() {
        return this.writer == null || Thread.holdsLock(this.writer);
    }

    public IndexFileDeleter(Directory directory, IndexDeletionPolicy indexDeletionPolicy, SegmentInfos segmentInfos, PrintStream printStream, IndexWriter indexWriter) throws CorruptIndexException, IOException {
        this.infoStream = printStream;
        this.writer = indexWriter;
        String string = segmentInfos.getCurrentSegmentFileName();
        if (printStream != null) {
            this.message("init: current segments file is \"" + string + "\"; deletionPolicy=" + indexDeletionPolicy);
        }
        this.policy = indexDeletionPolicy;
        this.directory = directory;
        long l = segmentInfos.getGeneration();
        IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
        CommitPoint commitPoint = null;
        String[] stringArray = null;
        try {
            stringArray = directory.listAll();
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {
            stringArray = new String[]{};
        }
        for (String string2 : stringArray) {
            if (!indexFileNameFilter.accept(null, string2) || string2.equals("segments.gen")) continue;
            this.getRefCount(string2);
            if (!string2.startsWith("segments")) continue;
            if (printStream != null) {
                this.message("init: load commit \"" + string2 + "\"");
            }
            SegmentInfos segmentInfos2 = new SegmentInfos();
            try {
                segmentInfos2.read(directory, string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (printStream != null) {
                    this.message("init: hit FileNotFoundException when loading commit \"" + string2 + "\"; skipping this commit point");
                }
                segmentInfos2 = null;
            }
            catch (IOException iOException) {
                if (SegmentInfos.generationFromSegmentsFileName(string2) <= l) {
                    throw iOException;
                }
                segmentInfos2 = null;
            }
            if (segmentInfos2 == null) continue;
            CommitPoint commitPoint2 = new CommitPoint(this.commitsToDelete, directory, segmentInfos2);
            if (segmentInfos2.getGeneration() == segmentInfos.getGeneration()) {
                commitPoint = commitPoint2;
            }
            this.commits.add(commitPoint2);
            this.incRef(segmentInfos2, true);
            if (this.lastSegmentInfos != null && segmentInfos2.getGeneration() <= this.lastSegmentInfos.getGeneration()) continue;
            this.lastSegmentInfos = segmentInfos2;
        }
        if (commitPoint == null && string != null) {
            SegmentInfos segmentInfos3 = new SegmentInfos();
            try {
                segmentInfos3.read(directory, string);
            }
            catch (IOException iOException) {
                throw new CorruptIndexException("failed to locate current segments_N file");
            }
            if (printStream != null) {
                this.message("forced open of current segments file " + segmentInfos.getCurrentSegmentFileName());
            }
            commitPoint = new CommitPoint(this.commitsToDelete, directory, segmentInfos3);
            this.commits.add(commitPoint);
            this.incRef(segmentInfos3, true);
        }
        CollectionUtil.mergeSort(this.commits);
        for (Map.Entry entry : this.refCounts.entrySet()) {
            String string2;
            RefCount refCount = (RefCount)entry.getValue();
            string2 = (String)entry.getKey();
            if (0 != refCount.count) continue;
            if (printStream != null) {
                this.message("init: removing unreferenced file \"" + string2 + "\"");
            }
            this.deleteFile(string2);
        }
        if (string != null) {
            indexDeletionPolicy.onInit(this.commits);
        }
        this.checkpoint(segmentInfos, false);
        this.startingCommitDeleted = commitPoint == null ? false : commitPoint.isDeleted();
        this.deleteCommits();
    }

    public SegmentInfos getLastSegmentInfos() {
        return this.lastSegmentInfos;
    }

    private void deleteCommits() throws IOException {
        int n = this.commitsToDelete.size();
        if (n > 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                CommitPoint commitPoint = this.commitsToDelete.get(n2);
                if (this.infoStream != null) {
                    this.message("deleteCommits: now decRef commit \"" + commitPoint.getSegmentsFileName() + "\"");
                }
                for (String string : commitPoint.files) {
                    this.decRef(string);
                }
            }
            this.commitsToDelete.clear();
            n = this.commits.size();
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                CommitPoint commitPoint = this.commits.get(n2);
                if (commitPoint.deleted) continue;
                if (n3 != n2) {
                    this.commits.set(n3, this.commits.get(n2));
                }
                ++n3;
            }
            while (n > n3) {
                this.commits.remove(n - 1);
                --n;
            }
        }
    }

    public void refresh(String string) throws IOException {
        String string2;
        String string3;
        assert (this.locked());
        String[] stringArray = this.directory.listAll();
        IndexFileNameFilter indexFileNameFilter = IndexFileNameFilter.getFilter();
        if (string != null) {
            string3 = string + ".";
            string2 = string + "_";
        } else {
            string3 = null;
            string2 = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!indexFileNameFilter.accept(null, string4) || string != null && !string4.startsWith(string3) && !string4.startsWith(string2) || this.refCounts.containsKey(string4) || string4.equals("segments.gen")) continue;
            if (this.infoStream != null) {
                this.message("refresh [prefix=" + string + "]: removing newly created unreferenced file \"" + string4 + "\"");
            }
            this.deleteFile(string4);
        }
    }

    public void refresh() throws IOException {
        assert (this.locked());
        this.deletable = null;
        this.refresh(null);
    }

    public void close() throws IOException {
        assert (this.locked());
        int n = this.lastFiles.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.decRef(this.lastFiles.get(i));
            }
            this.lastFiles.clear();
        }
        this.deletePendingFiles();
    }

    void revisitPolicy() throws IOException {
        assert (this.locked());
        if (this.infoStream != null) {
            this.message("now revisitPolicy");
        }
        if (this.commits.size() > 0) {
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        }
    }

    public void deletePendingFiles() throws IOException {
        assert (this.locked());
        if (this.deletable != null) {
            List<String> list = this.deletable;
            this.deletable = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (this.infoStream != null) {
                    this.message("delete pending file " + list.get(i));
                }
                this.deleteFile(list.get(i));
            }
        }
    }

    public void checkpoint(SegmentInfos segmentInfos, boolean bl) throws IOException {
        assert (this.locked());
        if (this.infoStream != null) {
            this.message("now checkpoint \"" + segmentInfos.getCurrentSegmentFileName() + "\" [" + segmentInfos.size() + " segments " + "; isCommit = " + bl + "]");
        }
        this.deletePendingFiles();
        this.incRef(segmentInfos, bl);
        if (bl) {
            this.commits.add(new CommitPoint(this.commitsToDelete, this.directory, segmentInfos));
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        } else {
            for (Collection<String> collection : this.lastFiles) {
                this.decRef(collection);
            }
            this.lastFiles.clear();
            this.lastFiles.add(segmentInfos.files(this.directory, false));
        }
    }

    void incRef(SegmentInfos segmentInfos, boolean bl) throws IOException {
        assert (this.locked());
        for (String string : segmentInfos.files(this.directory, bl)) {
            this.incRef(string);
        }
    }

    void incRef(Collection<String> collection) throws IOException {
        assert (this.locked());
        for (String string : collection) {
            this.incRef(string);
        }
    }

    void incRef(String string) throws IOException {
        assert (this.locked());
        RefCount refCount = this.getRefCount(string);
        if (this.infoStream != null && VERBOSE_REF_COUNTS) {
            this.message("  IncRef \"" + string + "\": pre-incr count is " + refCount.count);
        }
        refCount.IncRef();
    }

    void decRef(Collection<String> collection) throws IOException {
        assert (this.locked());
        for (String string : collection) {
            this.decRef(string);
        }
    }

    void decRef(String string) throws IOException {
        assert (this.locked());
        RefCount refCount = this.getRefCount(string);
        if (this.infoStream != null && VERBOSE_REF_COUNTS) {
            this.message("  DecRef \"" + string + "\": pre-decr count is " + refCount.count);
        }
        if (0 == refCount.DecRef()) {
            this.deleteFile(string);
            this.refCounts.remove(string);
        }
    }

    void decRef(SegmentInfos segmentInfos) throws IOException {
        assert (this.locked());
        for (String string : segmentInfos.files(this.directory, false)) {
            this.decRef(string);
        }
    }

    public boolean exists(String string) {
        assert (this.locked());
        if (!this.refCounts.containsKey(string)) {
            return false;
        }
        return this.getRefCount((String)string).count > 0;
    }

    private RefCount getRefCount(String string) {
        RefCount refCount;
        assert (this.locked());
        if (!this.refCounts.containsKey(string)) {
            refCount = new RefCount(string);
            this.refCounts.put(string, refCount);
        } else {
            refCount = this.refCounts.get(string);
        }
        return refCount;
    }

    void deleteFiles(List<String> list) throws IOException {
        assert (this.locked());
        for (String string : list) {
            this.deleteFile(string);
        }
    }

    void deleteNewFiles(Collection<String> collection) throws IOException {
        assert (this.locked());
        for (String string : collection) {
            if (this.refCounts.containsKey(string)) continue;
            if (this.infoStream != null) {
                this.message("delete new file \"" + string + "\"");
            }
            this.deleteFile(string);
        }
    }

    void deleteFile(String string) throws IOException {
        block6: {
            assert (this.locked());
            try {
                if (this.infoStream != null) {
                    this.message("delete \"" + string + "\"");
                }
                this.directory.deleteFile(string);
            }
            catch (IOException iOException) {
                if (!this.directory.fileExists(string)) break block6;
                if (this.infoStream != null) {
                    this.message("unable to remove file \"" + string + "\": " + iOException.toString() + "; Will re-try later.");
                }
                if (this.deletable == null) {
                    this.deletable = new ArrayList<String>();
                }
                this.deletable.add(string);
            }
        }
    }

    private static final class CommitPoint
    extends IndexCommit {
        Collection<String> files;
        String segmentsFileName;
        boolean deleted;
        Directory directory;
        Collection<CommitPoint> commitsToDelete;
        long version;
        long generation;
        final Map<String, String> userData;
        private final int segmentCount;

        public CommitPoint(Collection<CommitPoint> collection, Directory directory, SegmentInfos segmentInfos) throws IOException {
            this.directory = directory;
            this.commitsToDelete = collection;
            this.userData = segmentInfos.getUserData();
            this.segmentsFileName = segmentInfos.getCurrentSegmentFileName();
            this.version = segmentInfos.getVersion();
            this.generation = segmentInfos.getGeneration();
            this.files = Collections.unmodifiableCollection(segmentInfos.files(directory, true));
            this.segmentCount = segmentInfos.size();
        }

        public String toString() {
            return "IndexFileDeleter.CommitPoint(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() throws IOException {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.directory;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            if (!this.deleted) {
                this.deleted = true;
                this.commitsToDelete.add(this);
            }
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }
    }

    private static final class RefCount {
        final String fileName;
        boolean initDone;
        int count;

        RefCount(String string) {
            this.fileName = string;
        }

        public int IncRef() {
            if (!this.initDone) {
                this.initDone = true;
            } else assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-increment for file \"" + this.fileName + "\"";
            return ++this.count;
        }

        public int DecRef() {
            assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-decrement for file \"" + this.fileName + "\"";
            return --this.count;
        }
    }
}

