/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.store.Directory;

public abstract class IndexCommit
implements Comparable<IndexCommit> {
    public abstract String getSegmentsFileName();

    public abstract Collection<String> getFileNames() throws IOException;

    public abstract Directory getDirectory();

    public abstract void delete();

    public abstract boolean isDeleted();

    public abstract int getSegmentCount();

    public boolean equals(Object object) {
        if (object instanceof IndexCommit) {
            IndexCommit indexCommit = (IndexCommit)object;
            return indexCommit.getDirectory().equals(this.getDirectory()) && indexCommit.getVersion() == this.getVersion();
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)this.getDirectory().hashCode() + this.getVersion());
    }

    public abstract long getVersion();

    public abstract long getGeneration();

    public long getTimestamp() throws IOException {
        return this.getDirectory().fileModified(this.getSegmentsFileName());
    }

    public abstract Map<String, String> getUserData() throws IOException;

    @Override
    public int compareTo(IndexCommit indexCommit) {
        long l;
        long l2 = this.getGeneration();
        if (l2 < (l = indexCommit.getGeneration())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }
}

