/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsDocsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsWriter;
import org.apache.lucene.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.FreqProxFieldMergeState;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.UnicodeUtil;

final class FreqProxTermsWriter
extends TermsHashConsumer {
    private byte[] payloadBuffer;
    final UnicodeUtil.UTF8Result termsUTF8 = new UnicodeUtil.UTF8Result();

    FreqProxTermsWriter() {
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread termsHashPerThread) {
        return new FreqProxTermsWriterPerThread(termsHashPerThread);
    }

    private static int compareText(char[] cArray, int n, char[] cArray2, int n2) {
        char c;
        do {
            char c2;
            if ((c = cArray[n++]) == (c2 = cArray2[n2++])) continue;
            if ('\uffff' == c2) {
                return 1;
            }
            if ('\uffff' == c) {
                return -1;
            }
            return c - c2;
        } while ('\uffff' != c);
        return 0;
    }

    @Override
    void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> map, SegmentWriteState segmentWriteState) throws IOException {
        ArrayList<FreqProxTermsWriterPerField> arrayList = new ArrayList<FreqProxTermsWriterPerField>();
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> object2 : map.entrySet()) {
            Collection<TermsHashConsumerPerField> n2 = object2.getValue();
            for (TermsHashConsumerPerField termsHashConsumerPerField : n2) {
                FreqProxTermsWriterPerField freqProxTermsWriterPerField = (FreqProxTermsWriterPerField)termsHashConsumerPerField;
                if (freqProxTermsWriterPerField.termsHashPerField.numPostings <= 0) continue;
                arrayList.add(freqProxTermsWriterPerField);
            }
        }
        CollectionUtil.quickSort(arrayList);
        int n = arrayList.size();
        FormatPostingsFieldsWriter formatPostingsFieldsWriter = new FormatPostingsFieldsWriter(segmentWriteState, this.fieldInfos);
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                FieldInfo fieldInfo = ((FreqProxTermsWriterPerField)arrayList.get((int)n2)).fieldInfo;
                String string = fieldInfo.name;
                for (n4 = n2 + 1; n4 < n && ((FreqProxTermsWriterPerField)arrayList.get((int)n4)).fieldInfo.name.equals(string); ++n4) {
                }
                FreqProxTermsWriterPerField[] freqProxTermsWriterPerFieldArray = new FreqProxTermsWriterPerField[n4 - n2];
                for (n3 = n2; n3 < n4; ++n3) {
                    freqProxTermsWriterPerFieldArray[n3 - n2] = (FreqProxTermsWriterPerField)arrayList.get(n3);
                    if (fieldInfo.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) continue;
                    fieldInfo.storePayloads |= freqProxTermsWriterPerFieldArray[n3 - n2].hasPayloads;
                }
                this.appendPostings(string, segmentWriteState, freqProxTermsWriterPerFieldArray, formatPostingsFieldsWriter);
                for (n3 = 0; n3 < freqProxTermsWriterPerFieldArray.length; ++n3) {
                    TermsHashPerField termsHashPerField = freqProxTermsWriterPerFieldArray[n3].termsHashPerField;
                    int n5 = termsHashPerField.numPostings;
                    termsHashPerField.reset();
                    termsHashPerField.shrinkHash(n5);
                    freqProxTermsWriterPerFieldArray[n3].reset();
                }
                n2 = n4;
            }
            for (Map.Entry entry : map.entrySet()) {
                FreqProxTermsWriterPerThread freqProxTermsWriterPerThread = (FreqProxTermsWriterPerThread)entry.getKey();
                freqProxTermsWriterPerThread.termsHashPerThread.reset(true);
            }
        }
        finally {
            ((FormatPostingsFieldsConsumer)formatPostingsFieldsWriter).finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendPostings(String string, SegmentWriteState segmentWriteState, FreqProxTermsWriterPerField[] freqProxTermsWriterPerFieldArray, FormatPostingsFieldsConsumer formatPostingsFieldsConsumer) throws CorruptIndexException, IOException {
        Object object;
        int n = freqProxTermsWriterPerFieldArray.length;
        FreqProxFieldMergeState[] freqProxFieldMergeStateArray = new FreqProxFieldMergeState[n];
        for (int i = 0; i < n; ++i) {
            freqProxFieldMergeStateArray[i] = new FreqProxFieldMergeState(freqProxTermsWriterPerFieldArray[i]);
            object = freqProxFieldMergeStateArray[i];
            assert (((FreqProxFieldMergeState)object).field.fieldInfo == freqProxTermsWriterPerFieldArray[0].fieldInfo);
            boolean bl = ((FreqProxFieldMergeState)object).nextTerm();
            assert (bl);
        }
        FormatPostingsTermsConsumer formatPostingsTermsConsumer = formatPostingsFieldsConsumer.addField(freqProxTermsWriterPerFieldArray[0].fieldInfo);
        object = new Term(string);
        FreqProxFieldMergeState[] freqProxFieldMergeStateArray2 = new FreqProxFieldMergeState[n];
        FieldInfo.IndexOptions indexOptions = freqProxTermsWriterPerFieldArray[0].fieldInfo.indexOptions;
        Map<Term, Integer> map = segmentWriteState.segDeletes != null && segmentWriteState.segDeletes.terms.size() > 0 ? segmentWriteState.segDeletes.terms : null;
        try {
            while (n > 0) {
                Integer n2;
                int n3;
                freqProxFieldMergeStateArray2[0] = freqProxFieldMergeStateArray[0];
                int n4 = 1;
                for (int i = 1; i < n; ++i) {
                    char[] cArray = freqProxFieldMergeStateArray[i].text;
                    int n5 = freqProxFieldMergeStateArray[i].textOffset;
                    n3 = FreqProxTermsWriter.compareText(cArray, n5, freqProxFieldMergeStateArray2[0].text, freqProxFieldMergeStateArray2[0].textOffset);
                    if (n3 < 0) {
                        freqProxFieldMergeStateArray2[0] = freqProxFieldMergeStateArray[i];
                        n4 = 1;
                        continue;
                    }
                    if (n3 != 0) continue;
                    freqProxFieldMergeStateArray2[n4++] = freqProxFieldMergeStateArray[i];
                }
                FormatPostingsDocsConsumer formatPostingsDocsConsumer = formatPostingsTermsConsumer.addTerm(freqProxFieldMergeStateArray2[0].text, freqProxFieldMergeStateArray2[0].textOffset);
                int n6 = map != null ? ((n2 = map.get(((Term)object).createTerm(freqProxFieldMergeStateArray2[0].termText()))) != null ? n2 : 0) : 0;
                try {
                    while (n4 > 0) {
                        int n7;
                        int n8;
                        FreqProxFieldMergeState freqProxFieldMergeState = freqProxFieldMergeStateArray2[0];
                        for (n3 = 1; n3 < n4; ++n3) {
                            if (freqProxFieldMergeStateArray2[n3].docID >= freqProxFieldMergeState.docID) continue;
                            freqProxFieldMergeState = freqProxFieldMergeStateArray2[n3];
                        }
                        n3 = freqProxFieldMergeState.termFreq;
                        FormatPostingsPositionsConsumer formatPostingsPositionsConsumer = formatPostingsDocsConsumer.addDoc(freqProxFieldMergeState.docID, n3);
                        if (freqProxFieldMergeState.docID < n6) {
                            if (segmentWriteState.deletedDocs == null) {
                                segmentWriteState.deletedDocs = new BitVector(segmentWriteState.numDocs);
                            }
                            segmentWriteState.deletedDocs.set(freqProxFieldMergeState.docID);
                        }
                        ByteSliceReader byteSliceReader = freqProxFieldMergeState.prox;
                        if (indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                            try {
                                n8 = 0;
                                for (n7 = 0; n7 < n3; ++n7) {
                                    int n9;
                                    int n10 = byteSliceReader.readVInt();
                                    n8 += n10 >> 1;
                                    if ((n10 & 1) != 0) {
                                        n9 = byteSliceReader.readVInt();
                                        if (this.payloadBuffer == null || this.payloadBuffer.length < n9) {
                                            this.payloadBuffer = new byte[n9];
                                        }
                                        byteSliceReader.readBytes(this.payloadBuffer, 0, n9);
                                    } else {
                                        n9 = 0;
                                    }
                                    formatPostingsPositionsConsumer.addPosition(n8, this.payloadBuffer, 0, n9);
                                }
                            }
                            finally {
                                formatPostingsPositionsConsumer.finish();
                            }
                        }
                        if (freqProxFieldMergeState.nextDoc()) continue;
                        n8 = 0;
                        for (n7 = 0; n7 < n4; ++n7) {
                            if (freqProxFieldMergeStateArray2[n7] == freqProxFieldMergeState) continue;
                            freqProxFieldMergeStateArray2[n8++] = freqProxFieldMergeStateArray2[n7];
                        }
                        assert (n8 == --n4);
                        if (freqProxFieldMergeState.nextTerm()) continue;
                        n8 = 0;
                        for (n7 = 0; n7 < n; ++n7) {
                            if (freqProxFieldMergeStateArray[n7] == freqProxFieldMergeState) continue;
                            freqProxFieldMergeStateArray[n8++] = freqProxFieldMergeStateArray[n7];
                        }
                        assert (n8 == --n);
                    }
                }
                finally {
                    formatPostingsDocsConsumer.finish();
                }
            }
        }
        finally {
            formatPostingsTermsConsumer.finish();
        }
    }
}

