/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsDocsConsumer;
import org.apache.lucene.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.index.FormatPostingsPositionsWriter;
import org.apache.lucene.index.FormatPostingsTermsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;

final class FormatPostingsDocsWriter
extends FormatPostingsDocsConsumer
implements Closeable {
    final IndexOutput out;
    final FormatPostingsTermsWriter parent;
    final FormatPostingsPositionsWriter posWriter;
    final DefaultSkipListWriter skipListWriter;
    final int skipInterval;
    final int totalNumDocs;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;
    long freqStart;
    FieldInfo fieldInfo;
    int lastDocID;
    int df;
    private final TermInfo termInfo = new TermInfo();
    final UnicodeUtil.UTF8Result utf8 = new UnicodeUtil.UTF8Result();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FormatPostingsDocsWriter(SegmentWriteState segmentWriteState, FormatPostingsTermsWriter formatPostingsTermsWriter) throws IOException {
        this.parent = formatPostingsTermsWriter;
        this.out = formatPostingsTermsWriter.parent.dir.createOutput(IndexFileNames.segmentFileName(formatPostingsTermsWriter.parent.segment, "frq"));
        boolean bl = false;
        try {
            this.totalNumDocs = formatPostingsTermsWriter.parent.totalNumDocs;
            this.skipInterval = formatPostingsTermsWriter.parent.termsOut.skipInterval;
            this.skipListWriter = formatPostingsTermsWriter.parent.skipListWriter;
            this.skipListWriter.setFreqOutput(this.out);
            this.posWriter = new FormatPostingsPositionsWriter(segmentWriteState, this);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.out);
            throw throwable;
        }
    }

    void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.omitTermFreqAndPositions = fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY;
        this.storePayloads = fieldInfo.storePayloads;
        this.posWriter.setField(fieldInfo);
    }

    @Override
    FormatPostingsPositionsConsumer addDoc(int n, int n2) throws IOException {
        int n3 = n - this.lastDocID;
        if (n < 0 || this.df > 0 && n3 <= 0) {
            throw new CorruptIndexException("docs out of order (" + n + " <= " + this.lastDocID + " ) (out: " + this.out + ")");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.posWriter.lastPayloadLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        assert (n < this.totalNumDocs) : "docID=" + n + " totalNumDocs=" + this.totalNumDocs;
        this.lastDocID = n;
        if (this.omitTermFreqAndPositions) {
            this.out.writeVInt(n3);
        } else if (1 == n2) {
            this.out.writeVInt(n3 << 1 | 1);
        } else {
            this.out.writeVInt(n3 << 1);
            this.out.writeVInt(n2);
        }
        return this.posWriter;
    }

    @Override
    void finish() throws IOException {
        long l = this.skipListWriter.writeSkip(this.out);
        this.termInfo.set(this.df, this.parent.freqStart, this.parent.proxStart, (int)(l - this.parent.freqStart));
        UnicodeUtil.UTF16toUTF8(this.parent.currentTerm, this.parent.currentTermStart, this.utf8);
        if (this.df > 0) {
            this.parent.termsOut.add(this.fieldInfo.number, this.utf8.result, this.utf8.length, this.termInfo);
        }
        this.lastDocID = 0;
        this.df = 0;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.out, this.posWriter);
    }
}

