/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class ByteSliceReader
extends IndexInput {
    ByteBlockPool pool;
    int bufferUpto;
    byte[] buffer;
    public int upto;
    int limit;
    int level;
    public int bufferOffset;
    public int endIndex;

    ByteSliceReader() {
    }

    public void init(ByteBlockPool byteBlockPool, int n, int n2) {
        assert (n2 - n >= 0);
        assert (n >= 0);
        assert (n2 >= 0);
        this.pool = byteBlockPool;
        this.endIndex = n2;
        this.level = 0;
        this.bufferUpto = n / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        this.buffer = byteBlockPool.buffers[this.bufferUpto];
        this.upto = n & Short.MAX_VALUE;
        int n3 = ByteBlockPool.levelSizeArray[0];
        this.limit = n + n3 >= n2 ? n2 & Short.MAX_VALUE : this.upto + n3 - 4;
    }

    public boolean eof() {
        assert (this.upto + this.bufferOffset <= this.endIndex);
        return this.upto + this.bufferOffset == this.endIndex;
    }

    @Override
    public byte readByte() {
        assert (!this.eof());
        assert (this.upto <= this.limit);
        if (this.upto == this.limit) {
            this.nextSlice();
        }
        return this.buffer[this.upto++];
    }

    public long writeTo(IndexOutput indexOutput) throws IOException {
        long l = 0L;
        while (true) {
            if (this.limit + this.bufferOffset == this.endIndex) {
                assert (this.endIndex - this.bufferOffset >= this.upto);
                break;
            }
            indexOutput.writeBytes(this.buffer, this.upto, this.limit - this.upto);
            l += (long)(this.limit - this.upto);
            this.nextSlice();
        }
        indexOutput.writeBytes(this.buffer, this.upto, this.limit - this.upto);
        return l += (long)(this.limit - this.upto);
    }

    public void nextSlice() {
        int n = ((this.buffer[this.limit] & 0xFF) << 24) + ((this.buffer[1 + this.limit] & 0xFF) << 16) + ((this.buffer[2 + this.limit] & 0xFF) << 8) + (this.buffer[3 + this.limit] & 0xFF);
        this.level = ByteBlockPool.nextLevelArray[this.level];
        int n2 = ByteBlockPool.levelSizeArray[this.level];
        this.bufferUpto = n / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        this.buffer = this.pool.buffers[this.bufferUpto];
        this.upto = n & Short.MAX_VALUE;
        if (n + n2 >= this.endIndex) {
            assert (this.endIndex - n > 0);
            this.limit = this.endIndex - this.bufferOffset;
        } else {
            this.limit = this.upto + n2 - 4;
        }
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.limit - this.upto;
            if (n3 < n2) {
                System.arraycopy(this.buffer, this.upto, byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.nextSlice();
                continue;
            }
            System.arraycopy(this.buffer, this.upto, byArray, n, n2);
            this.upto += n2;
            break;
        }
    }

    @Override
    public long getFilePointer() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public long length() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void seek(long l) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void close() {
        throw new RuntimeException("not implemented");
    }
}

