/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CoalescedDeletes;
import org.apache.lucene.index.FrozenBufferedDeletes;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;

class BufferedDeletesStream {
    private final List<FrozenBufferedDeletes> deletes = new ArrayList<FrozenBufferedDeletes>();
    private long nextGen = 1L;
    private Term lastDeleteTerm;
    private PrintStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private final int messageID;
    private static final Comparator<SegmentInfo> sortByDelGen = new Comparator<SegmentInfo>(){

        @Override
        public int compare(SegmentInfo segmentInfo, SegmentInfo segmentInfo2) {
            long l = segmentInfo.getBufferedDeletesGen() - segmentInfo2.getBufferedDeletesGen();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return 0;
        }
    };

    public BufferedDeletesStream(int n) {
        this.messageID = n;
    }

    private synchronized void message(String string) {
        if (this.infoStream != null) {
            this.infoStream.println("BD " + this.messageID + " [" + new Date() + "; " + Thread.currentThread().getName() + "]: " + string);
        }
    }

    public synchronized void setInfoStream(PrintStream printStream) {
        this.infoStream = printStream;
    }

    public synchronized void push(FrozenBufferedDeletes frozenBufferedDeletes) {
        assert (frozenBufferedDeletes.any());
        assert (this.checkDeleteStats());
        assert (frozenBufferedDeletes.gen < this.nextGen);
        this.deletes.add(frozenBufferedDeletes);
        this.numTerms.addAndGet(frozenBufferedDeletes.numTermDeletes);
        this.bytesUsed.addAndGet(frozenBufferedDeletes.bytesUsed);
        if (this.infoStream != null) {
            this.message("push deletes " + frozenBufferedDeletes + " delGen=" + frozenBufferedDeletes.gen + " packetCount=" + this.deletes.size());
        }
        assert (this.checkDeleteStats());
    }

    public synchronized void clear() {
        this.deletes.clear();
        this.nextGen = 1L;
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ApplyDeletesResult applyDeletes(IndexWriter.ReaderPool readerPool, List<SegmentInfo> list) throws IOException {
        long l = System.currentTimeMillis();
        if (list.size() == 0) {
            return new ApplyDeletesResult(false, this.nextGen++, null);
        }
        assert (this.checkDeleteStats());
        if (!this.any()) {
            this.message("applyDeletes: no deletes; skipping");
            return new ApplyDeletesResult(false, this.nextGen++, null);
        }
        if (this.infoStream != null) {
            this.message("applyDeletes: infos=" + list + " packetCount=" + this.deletes.size());
        }
        ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
        arrayList.addAll(list);
        Collections.sort(arrayList, sortByDelGen);
        CoalescedDeletes coalescedDeletes = null;
        boolean bl = false;
        int n = arrayList.size() - 1;
        int n2 = this.deletes.size() - 1;
        ArrayList<SegmentInfo> arrayList2 = null;
        while (n >= 0) {
            boolean bl2;
            int n3;
            SegmentReader segmentReader;
            FrozenBufferedDeletes frozenBufferedDeletes = n2 >= 0 ? this.deletes.get(n2) : null;
            SegmentInfo segmentInfo = (SegmentInfo)arrayList.get(n);
            long l2 = segmentInfo.getBufferedDeletesGen();
            if (frozenBufferedDeletes != null && l2 < frozenBufferedDeletes.gen) {
                if (coalescedDeletes == null) {
                    coalescedDeletes = new CoalescedDeletes();
                }
                coalescedDeletes.update(frozenBufferedDeletes);
                --n2;
                continue;
            }
            if (frozenBufferedDeletes != null && l2 == frozenBufferedDeletes.gen) {
                assert (readerPool.infoIsLive(segmentInfo));
                segmentReader = readerPool.get(segmentInfo, false);
                n3 = 0;
                try {
                    if (coalescedDeletes != null) {
                        n3 = (int)((long)n3 + this.applyTermDeletes(coalescedDeletes.termsIterable(), segmentReader));
                        n3 = (int)((long)n3 + this.applyQueryDeletes(coalescedDeletes.queriesIterable(), segmentReader));
                    }
                    n3 = (int)((long)n3 + this.applyQueryDeletes(frozenBufferedDeletes.queriesIterable(), segmentReader));
                    bl2 = segmentReader.numDocs() == 0;
                }
                finally {
                    readerPool.release(segmentReader);
                }
                bl |= n3 > 0;
                if (bl2) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<SegmentInfo>();
                    }
                    arrayList2.add(segmentInfo);
                }
                if (this.infoStream != null) {
                    this.message("seg=" + segmentInfo + " segGen=" + l2 + " segDeletes=[" + frozenBufferedDeletes + "]; coalesced deletes=[" + (coalescedDeletes == null ? "null" : coalescedDeletes) + "] delCount=" + n3 + (bl2 ? " 100% deleted" : ""));
                }
                if (coalescedDeletes == null) {
                    coalescedDeletes = new CoalescedDeletes();
                }
                coalescedDeletes.update(frozenBufferedDeletes);
                --n2;
                --n;
                segmentInfo.setBufferedDeletesGen(this.nextGen);
                continue;
            }
            if (coalescedDeletes != null) {
                assert (readerPool.infoIsLive(segmentInfo));
                segmentReader = readerPool.get(segmentInfo, false);
                n3 = 0;
                try {
                    n3 = (int)((long)n3 + this.applyTermDeletes(coalescedDeletes.termsIterable(), segmentReader));
                    n3 = (int)((long)n3 + this.applyQueryDeletes(coalescedDeletes.queriesIterable(), segmentReader));
                    bl2 = segmentReader.numDocs() == 0;
                }
                finally {
                    readerPool.release(segmentReader);
                }
                bl |= n3 > 0;
                if (bl2) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList();
                    }
                    arrayList2.add(segmentInfo);
                }
                if (this.infoStream != null) {
                    this.message("seg=" + segmentInfo + " segGen=" + l2 + " coalesced deletes=[" + (coalescedDeletes == null ? "null" : coalescedDeletes) + "] delCount=" + n3 + (bl2 ? " 100% deleted" : ""));
                }
            }
            segmentInfo.setBufferedDeletesGen(this.nextGen);
            --n;
        }
        assert (this.checkDeleteStats());
        if (this.infoStream != null) {
            this.message("applyDeletes took " + (System.currentTimeMillis() - l) + " msec");
        }
        return new ApplyDeletesResult(bl, this.nextGen++, arrayList2);
    }

    public synchronized long getNextGen() {
        return this.nextGen++;
    }

    public synchronized void prune(SegmentInfos segmentInfos) {
        assert (this.checkDeleteStats());
        long l = Long.MAX_VALUE;
        for (SegmentInfo segmentInfo : segmentInfos) {
            l = Math.min(segmentInfo.getBufferedDeletesGen(), l);
        }
        if (this.infoStream != null) {
            this.message("prune sis=" + segmentInfos + " minGen=" + l + " packetCount=" + this.deletes.size());
        }
        int n = this.deletes.size();
        for (int i = 0; i < n; ++i) {
            if (this.deletes.get((int)i).gen < l) continue;
            this.prune(i);
            assert (this.checkDeleteStats());
            return;
        }
        this.prune(n);
        assert (!this.any());
        assert (this.checkDeleteStats());
    }

    private synchronized void prune(int n) {
        if (n > 0) {
            if (this.infoStream != null) {
                this.message("pruneDeletes: prune " + n + " packets; " + (this.deletes.size() - n) + " packets remain");
            }
            for (int i = 0; i < n; ++i) {
                FrozenBufferedDeletes frozenBufferedDeletes = this.deletes.get(i);
                this.numTerms.addAndGet(-frozenBufferedDeletes.numTermDeletes);
                assert (this.numTerms.get() >= 0);
                this.bytesUsed.addAndGet(-frozenBufferedDeletes.bytesUsed);
                assert (this.bytesUsed.get() >= 0L);
            }
            this.deletes.subList(0, n).clear();
        }
    }

    private synchronized long applyTermDeletes(Iterable<Term> iterable, SegmentReader segmentReader) throws IOException {
        long l = 0L;
        assert (this.checkDeleteTerm(null));
        TermDocs termDocs = segmentReader.termDocs();
        for (Term term : iterable) {
            assert (this.checkDeleteTerm(term));
            termDocs.seek(term);
            while (termDocs.next()) {
                int n = termDocs.doc();
                segmentReader.deleteDocument(n);
                ++l;
            }
        }
        return l;
    }

    private synchronized long applyQueryDeletes(Iterable<QueryAndLimit> iterable, SegmentReader segmentReader) throws IOException {
        long l = 0L;
        for (QueryAndLimit queryAndLimit : iterable) {
            int n;
            DocIdSetIterator docIdSetIterator;
            Query query = queryAndLimit.query;
            int n2 = queryAndLimit.limit;
            DocIdSet docIdSet = new QueryWrapperFilter(query).getDocIdSet(segmentReader);
            if (docIdSet == null || (docIdSetIterator = docIdSet.iterator()) == null) continue;
            while ((n = docIdSetIterator.nextDoc()) < n2) {
                segmentReader.deleteDocument(n);
                ++l;
            }
        }
        return l;
    }

    private boolean checkDeleteTerm(Term term) {
        if (term != null) assert (this.lastDeleteTerm == null || term.compareTo(this.lastDeleteTerm) > 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + term;
        this.lastDeleteTerm = term == null ? null : new Term(term.field(), term.text());
        return true;
    }

    private boolean checkDeleteStats() {
        int n = 0;
        long l = 0L;
        for (FrozenBufferedDeletes frozenBufferedDeletes : this.deletes) {
            n += frozenBufferedDeletes.numTermDeletes;
            l += (long)frozenBufferedDeletes.bytesUsed;
        }
        assert (n == this.numTerms.get()) : "numTerms2=" + n + " vs " + this.numTerms.get();
        assert (l == this.bytesUsed.get()) : "bytesUsed2=" + l + " vs " + this.bytesUsed;
        return true;
    }

    public static class QueryAndLimit {
        public final Query query;
        public final int limit;

        public QueryAndLimit(Query query, int n) {
            this.query = query;
            this.limit = n;
        }
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final long gen;
        public final List<SegmentInfo> allDeleted;

        ApplyDeletesResult(boolean bl, long l, List<SegmentInfo> list) {
            this.anyDeletes = bl;
            this.gen = l;
            this.allDeleted = list;
        }
    }
}

