/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.collation.CollationKeyFilter;

public final class CollationKeyAnalyzer
extends Analyzer {
    private Collator collator;

    public CollationKeyAnalyzer(Collator collator) {
        this.collator = collator;
    }

    @Override
    public TokenStream tokenStream(String string, Reader reader) {
        TokenStream tokenStream = new KeywordTokenizer(reader);
        tokenStream = new CollationKeyFilter(tokenStream, this.collator);
        return tokenStream;
    }

    @Override
    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        SavedStreams savedStreams = (SavedStreams)this.getPreviousTokenStream();
        if (savedStreams == null) {
            savedStreams = new SavedStreams();
            savedStreams.source = new KeywordTokenizer(reader);
            savedStreams.result = new CollationKeyFilter(savedStreams.source, this.collator);
            this.setPreviousTokenStream(savedStreams);
        } else {
            savedStreams.source.reset(reader);
        }
        return savedStreams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

