/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.io.Serializable;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeImpl;

public class PositionIncrementAttributeImpl
extends AttributeImpl
implements PositionIncrementAttribute,
Cloneable,
Serializable {
    private int positionIncrement = 1;

    @Override
    public void setPositionIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + n);
        }
        this.positionIncrement = n;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public void clear() {
        this.positionIncrement = 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PositionIncrementAttributeImpl) {
            return this.positionIncrement == ((PositionIncrementAttributeImpl)object).positionIncrement;
        }
        return false;
    }

    public int hashCode() {
        return this.positionIncrement;
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)((Object)attributeImpl);
        positionIncrementAttribute.setPositionIncrement(this.positionIncrement);
    }
}

