/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;

public class Token
extends TermAttributeImpl
implements TypeAttribute,
PositionIncrementAttribute,
FlagsAttribute,
OffsetAttribute,
PayloadAttribute {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int flags;
    private Payload payload;
    private int positionIncrement = 1;
    public static final AttributeSource.AttributeFactory TOKEN_ATTRIBUTE_FACTORY = new TokenAttributeFactory(AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);

    public Token() {
    }

    public Token(int n, int n2) {
        this.startOffset = n;
        this.endOffset = n2;
    }

    public Token(int n, int n2, String string) {
        this.startOffset = n;
        this.endOffset = n2;
        this.type = string;
    }

    public Token(int n, int n2, int n3) {
        this.startOffset = n;
        this.endOffset = n2;
        this.flags = n3;
    }

    public Token(String string, int n, int n2) {
        this.append(string);
        this.startOffset = n;
        this.endOffset = n2;
    }

    public Token(String string, int n, int n2, String string2) {
        this.append(string);
        this.startOffset = n;
        this.endOffset = n2;
        this.type = string2;
    }

    public Token(String string, int n, int n2, int n3) {
        this.append(string);
        this.startOffset = n;
        this.endOffset = n2;
        this.flags = n3;
    }

    public Token(char[] cArray, int n, int n2, int n3, int n4) {
        this.copyBuffer(cArray, n, n2);
        this.startOffset = n3;
        this.endOffset = n4;
    }

    @Override
    public void setPositionIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + n);
        }
        this.positionIncrement = n;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    @Override
    public void setOffset(int n, int n2) {
        this.startOffset = n;
        this.endOffset = n2;
    }

    @Override
    public final String type() {
        return this.type;
    }

    @Override
    public final void setType(String string) {
        this.type = string;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int n) {
        this.flags = n;
    }

    @Override
    public Payload getPayload() {
        return this.payload;
    }

    @Override
    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    @Override
    public void clear() {
        super.clear();
        this.payload = null;
        this.positionIncrement = 1;
        this.flags = 0;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    @Override
    public Object clone() {
        Token token = (Token)super.clone();
        if (this.payload != null) {
            token.payload = (Payload)this.payload.clone();
        }
        return token;
    }

    public Token clone(char[] cArray, int n, int n2, int n3, int n4) {
        Token token = new Token(cArray, n, n2, n3, n4);
        token.positionIncrement = this.positionIncrement;
        token.flags = this.flags;
        token.type = this.type;
        if (this.payload != null) {
            token.payload = (Payload)this.payload.clone();
        }
        return token;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Token) {
            Token token = (Token)object;
            return this.startOffset == token.startOffset && this.endOffset == token.endOffset && this.flags == token.flags && this.positionIncrement == token.positionIncrement && (this.type == null ? token.type == null : this.type.equals(token.type)) && (this.payload == null ? token.payload == null : this.payload.equals(token.payload)) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.startOffset;
        n = n * 31 + this.endOffset;
        n = n * 31 + this.flags;
        n = n * 31 + this.positionIncrement;
        if (this.type != null) {
            n = n * 31 + this.type.hashCode();
        }
        if (this.payload != null) {
            n = n * 31 + this.payload.hashCode();
        }
        return n;
    }

    private void clearNoTermBuffer() {
        this.payload = null;
        this.positionIncrement = 1;
        this.flags = 0;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    public Token reinit(char[] cArray, int n, int n2, int n3, int n4, String string) {
        this.clearNoTermBuffer();
        this.copyBuffer(cArray, n, n2);
        this.payload = null;
        this.positionIncrement = 1;
        this.startOffset = n3;
        this.endOffset = n4;
        this.type = string;
        return this;
    }

    public Token reinit(char[] cArray, int n, int n2, int n3, int n4) {
        this.clearNoTermBuffer();
        this.copyBuffer(cArray, n, n2);
        this.startOffset = n3;
        this.endOffset = n4;
        this.type = "word";
        return this;
    }

    public Token reinit(String string, int n, int n2, String string2) {
        this.clear();
        this.append(string);
        this.startOffset = n;
        this.endOffset = n2;
        this.type = string2;
        return this;
    }

    public Token reinit(String string, int n, int n2, int n3, int n4, String string2) {
        this.clear();
        this.append(string, n, n + n2);
        this.startOffset = n3;
        this.endOffset = n4;
        this.type = string2;
        return this;
    }

    public Token reinit(String string, int n, int n2) {
        this.clear();
        this.append(string);
        this.startOffset = n;
        this.endOffset = n2;
        this.type = "word";
        return this;
    }

    public Token reinit(String string, int n, int n2, int n3, int n4) {
        this.clear();
        this.append(string, n, n + n2);
        this.startOffset = n3;
        this.endOffset = n4;
        this.type = "word";
        return this;
    }

    public void reinit(Token token) {
        this.copyBuffer(token.buffer(), 0, token.length());
        this.positionIncrement = token.positionIncrement;
        this.flags = token.flags;
        this.startOffset = token.startOffset;
        this.endOffset = token.endOffset;
        this.type = token.type;
        this.payload = token.payload;
    }

    public void reinit(Token token, String string) {
        this.setEmpty().append(string);
        this.positionIncrement = token.positionIncrement;
        this.flags = token.flags;
        this.startOffset = token.startOffset;
        this.endOffset = token.endOffset;
        this.type = token.type;
        this.payload = token.payload;
    }

    public void reinit(Token token, char[] cArray, int n, int n2) {
        this.copyBuffer(cArray, n, n2);
        this.positionIncrement = token.positionIncrement;
        this.flags = token.flags;
        this.startOffset = token.startOffset;
        this.endOffset = token.endOffset;
        this.type = token.type;
        this.payload = token.payload;
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        if (attributeImpl instanceof Token) {
            Token token = (Token)attributeImpl;
            token.reinit(this);
            if (this.payload != null) {
                token.payload = (Payload)this.payload.clone();
            }
        } else {
            super.copyTo(attributeImpl);
            ((OffsetAttribute)((Object)attributeImpl)).setOffset(this.startOffset, this.endOffset);
            ((PositionIncrementAttribute)((Object)attributeImpl)).setPositionIncrement(this.positionIncrement);
            ((PayloadAttribute)((Object)attributeImpl)).setPayload(this.payload == null ? null : (Payload)this.payload.clone());
            ((FlagsAttribute)((Object)attributeImpl)).setFlags(this.flags);
            ((TypeAttribute)((Object)attributeImpl)).setType(this.type);
        }
    }

    @Override
    public void reflectWith(AttributeReflector attributeReflector) {
        super.reflectWith(attributeReflector);
        attributeReflector.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        attributeReflector.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
        attributeReflector.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
        attributeReflector.reflect(PayloadAttribute.class, "payload", this.payload);
        attributeReflector.reflect(FlagsAttribute.class, "flags", this.flags);
        attributeReflector.reflect(TypeAttribute.class, "type", this.type);
    }

    public static final class TokenAttributeFactory
    extends AttributeSource.AttributeFactory {
        private final AttributeSource.AttributeFactory delegate;

        public TokenAttributeFactory(AttributeSource.AttributeFactory attributeFactory) {
            this.delegate = attributeFactory;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> clazz) {
            return clazz.isAssignableFrom(Token.class) ? new Token() : this.delegate.createAttributeInstance(clazz);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TokenAttributeFactory) {
                TokenAttributeFactory tokenAttributeFactory = (TokenAttributeFactory)object;
                return this.delegate.equals(tokenAttributeFactory.delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode() ^ 0xA45AA31;
        }
    }
}

