/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;

public final class PerFieldAnalyzerWrapper
extends Analyzer {
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();

    public PerFieldAnalyzerWrapper(Analyzer analyzer) {
        this(analyzer, null);
    }

    public PerFieldAnalyzerWrapper(Analyzer analyzer, Map<String, Analyzer> map) {
        this.defaultAnalyzer = analyzer;
        if (map != null) {
            this.analyzerMap.putAll(map);
        }
    }

    @Deprecated
    public void addAnalyzer(String string, Analyzer analyzer) {
        this.analyzerMap.put(string, analyzer);
    }

    @Override
    public TokenStream tokenStream(String string, Reader reader) {
        Analyzer analyzer = this.analyzerMap.get(string);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.tokenStream(string, reader);
    }

    @Override
    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        Analyzer analyzer = this.analyzerMap.get(string);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.reusableTokenStream(string, reader);
    }

    @Override
    public int getPositionIncrementGap(String string) {
        Analyzer analyzer = this.analyzerMap.get(string);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.getPositionIncrementGap(string);
    }

    @Override
    public int getOffsetGap(Fieldable fieldable) {
        Analyzer analyzer = this.analyzerMap.get(fieldable.name());
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.getOffsetGap(fieldable);
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.analyzerMap + ", default=" + this.defaultAnalyzer + ")";
    }
}

