/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.PatriciaTrie;

public class CharSequenceKeyAnalyzer
implements PatriciaTrie.KeyAnalyzer<CharSequence> {
    private static final long serialVersionUID = -7032449491269434877L;
    private static final int[] BITS = CharSequenceKeyAnalyzer.createIntBitMask(16);

    public static final int[] createIntBitMask(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1 << n - i - 1;
        }
        return nArray;
    }

    @Override
    public int length(CharSequence charSequence) {
        return charSequence != null ? charSequence.length() * 16 : 0;
    }

    @Override
    public int bitIndex(CharSequence charSequence, int n, int n2, CharSequence charSequence2, int n3, int n4) {
        boolean bl = true;
        if (n % 16 != 0 || n3 % 16 != 0 || n2 % 16 != 0 || n4 % 16 != 0) {
            throw new IllegalArgumentException("offsets & lengths must be at character boundaries");
        }
        int n5 = n / 16;
        int n6 = n3 / 16;
        int n7 = n2 / 16 + n5;
        int n8 = n4 / 16 + n6;
        int n9 = Math.max(n7, n8);
        char c = '\u0000';
        char c2 = '\u0000';
        for (int i = 0; i < n9; ++i) {
            int n10 = i + n5;
            int n11 = i + n6;
            c = n10 >= n7 ? (char)'\u0000' : charSequence.charAt(n10);
            if (c != (c2 = charSequence2 == null || n11 >= n8 ? (char)'\u0000' : charSequence2.charAt(n11))) {
                int n12 = c ^ c2;
                return i * 16 + (Integer.numberOfLeadingZeros(n12) - 16);
            }
            if (c == '\u0000') continue;
            bl = false;
        }
        if (bl) {
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isBitSet(CharSequence charSequence, int n, int n2) {
        if (charSequence == null || n2 >= n) {
            return false;
        }
        int n3 = n2 / BITS.length;
        int n4 = n2 - n3 * BITS.length;
        return (charSequence.charAt(n3) & BITS[n4]) != 0;
    }

    @Override
    public int compare(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence.toString().compareTo(charSequence2.toString());
    }

    @Override
    public int bitsPerElement() {
        return 16;
    }

    @Override
    public boolean isPrefix(CharSequence charSequence, int n, int n2, CharSequence charSequence2) {
        if (n % 16 != 0 || n2 % 16 != 0) {
            throw new IllegalArgumentException("Cannot determine prefix outside of character boundaries");
        }
        String string = charSequence.subSequence(n / 16, n2 / 16).toString();
        String string2 = charSequence2.toString();
        return string2.startsWith(string);
    }
}

