/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.AppUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Association {
    private String name;
    private String description;
    private String mimeType;
    private List<String> fileExtensionList;
    private String iconFileName;
    private List<Action> actionList;
    private int hashcode;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given MIME file name is null.");
        }
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given description is null.");
        }
        this.description = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given MIME type is null.");
        }
        this.mimeType = string;
    }

    public boolean addFileExtension(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given file extension is null.");
        }
        string = AppUtility.addDotToFileExtension(string);
        if (this.fileExtensionList == null) {
            this.fileExtensionList = new ArrayList<String>();
        }
        return this.fileExtensionList.add(string);
    }

    public boolean removeFileExtension(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given file extension is null.");
        }
        string = AppUtility.addDotToFileExtension(string);
        if (this.fileExtensionList != null) {
            return this.fileExtensionList.remove(string);
        }
        return false;
    }

    public List<String> getFileExtList() {
        if (this.fileExtensionList == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.fileExtensionList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public String getIconFileName() {
        return this.iconFileName;
    }

    public void setIconFileName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given icon file name is null.");
        }
        this.iconFileName = string;
    }

    public boolean addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("The given action is null.");
        }
        if (action.getVerb() == null) {
            throw new IllegalArgumentException("the given action object has null verb field.");
        }
        if (action.getCommand() == null) {
            throw new IllegalArgumentException("the given action object has null command field.");
        }
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
        }
        return this.actionList.add(new Action(action.getVerb(), action.getCommand(), action.getDescription()));
    }

    public boolean removeAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("The given action is null.");
        }
        if (action.getVerb() == null || action.getCommand() == null) {
            throw new IllegalArgumentException("the given action object has null verb field or command field.");
        }
        if (this.actionList != null) {
            return this.actionList.remove(action);
        }
        return false;
    }

    public List<Action> getActionList() {
        if (this.actionList == null || this.actionList.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Action>(this.actionList);
    }

    public Action getActionByVerb(String string) {
        Iterator<Action> iterator;
        if (this.actionList != null && (iterator = this.actionList.iterator()) != null) {
            while (iterator.hasNext()) {
                Action action = iterator.next();
                String string2 = action.getVerb();
                if (!string2.equalsIgnoreCase(string)) continue;
                return action;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Association)) {
            return false;
        }
        Association association = (Association)object;
        String string = association.getDescription();
        String string2 = association.getIconFileName();
        String string3 = association.getMimeType();
        boolean bl2 = (this.description == null ? string == null : this.description.equals(string)) && (this.iconFileName == null ? string2 == null : this.iconFileName.equals(string2)) && (this.mimeType == null ? string3 == null : this.mimeType.equals(string3)) ? true : (bl = false);
        if (!bl) {
            return false;
        }
        List<String> list = association.getFileExtList();
        boolean bl3 = false;
        if (this.fileExtensionList == null && list == null) {
            bl3 = true;
        } else if (this.fileExtensionList != null && list != null && this.fileExtensionList.containsAll(list) && list.containsAll(this.fileExtensionList)) {
            bl3 = true;
        }
        if (!bl3) {
            return false;
        }
        List<Action> list2 = association.getActionList();
        boolean bl4 = false;
        if (this.actionList == null && list2 != null) {
            bl4 = true;
        } else if (this.actionList != null && list2 != null && this.actionList.containsAll(list2) && list2.containsAll(this.actionList)) {
            bl4 = true;
        }
        return bl4;
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            int n = 17;
            if (this.name != null) {
                n = n * 37 + this.name.hashCode();
            }
            if (this.description != null) {
                n = n * 37 + this.description.hashCode();
            }
            if (this.mimeType != null) {
                n = n * 37 + this.mimeType.hashCode();
            }
            if (this.iconFileName != null) {
                n = n * 37 + this.iconFileName.hashCode();
            }
            if (this.fileExtensionList != null) {
                n = n * 37 + this.fileExtensionList.hashCode();
            }
            if (this.actionList != null) {
                n = n * 37 + this.actionList.hashCode();
            }
            this.hashcode = n;
        }
        return this.hashcode;
    }

    public String toString() {
        Iterator<Object> iterator;
        String string = "\r\n";
        String string2 = "";
        string2 = string2.concat("MIME File Name: ");
        if (this.name != null) {
            string2 = string2.concat(this.name);
        }
        string2 = string2.concat(string);
        string2 = string2.concat("Description: ");
        if (this.description != null) {
            string2 = string2.concat(this.description);
        }
        string2 = string2.concat(string);
        string2 = string2.concat("MIME Type: ");
        if (this.mimeType != null) {
            string2 = string2.concat(this.mimeType);
        }
        string2 = string2.concat(string);
        string2 = string2.concat("Icon File: ");
        if (this.iconFileName != null) {
            string2 = string2.concat(this.iconFileName);
        }
        string2 = string2.concat(string);
        string2 = string2.concat("File Extension: ");
        if (this.fileExtensionList != null && (iterator = this.fileExtensionList.iterator()) != null) {
            while (iterator.hasNext()) {
                string2 = string2.concat(iterator.next());
                if (!iterator.hasNext()) continue;
                string2 = string2.concat(" ");
            }
        }
        string2 = string2.concat(string);
        string2 = string2.concat("Action List: ");
        if (this.actionList != null && (iterator = this.actionList.iterator()) != null) {
            string2 = string2.concat(string);
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                string2 = string2.concat(action.toString());
            }
        }
        string2 = string2.concat(string);
        return string2;
    }
}

