/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import java.util.HashMap;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import org.appwork.storage.Storable;

public class AccountData
implements Storable {
    private HashMap<String, Object> properties;
    private String hoster;
    private int maxSimultanDownloads;
    private String password;
    private HashMap<String, Object> infoProperties;
    private long createTime;
    private long trafficLeft;
    private long trafficMax;
    private long validUntil;
    private String status;
    private boolean active;
    private boolean enabled;
    private boolean tempDisabled;
    private boolean valid;
    private boolean trafficUnlimited;
    private boolean specialtraffic;
    private String user;

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
    }

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String string) {
        this.hoster = string;
    }

    public int getMaxSimultanDownloads() {
        return this.maxSimultanDownloads;
    }

    public void setMaxSimultanDownloads(int n) {
        this.maxSimultanDownloads = n;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public static AccountData create(Account account) {
        AccountData accountData = new AccountData();
        accountData.properties = account.getProperties();
        if (account.getAccountInfo() != null) {
            accountData.infoProperties = account.getAccountInfo().getProperties();
            if (accountData.infoProperties == null) {
                accountData.infoProperties = new HashMap();
            }
            accountData.createTime = account.getAccountInfo().getCreateTime();
            accountData.trafficLeft = account.getAccountInfo().getTrafficLeft();
            accountData.trafficMax = account.getAccountInfo().getTrafficMax();
            accountData.validUntil = account.getAccountInfo().getValidUntil();
            accountData.status = account.getAccountInfo().getStatus();
            accountData.trafficUnlimited = account.getAccountInfo().isUnlimitedTraffic();
            accountData.specialtraffic = account.getAccountInfo().isSpecialTraffic();
        }
        accountData.active = account.isActive();
        accountData.enabled = account.isEnabled();
        accountData.tempDisabled = account.isTempDisabled();
        accountData.valid = account.isValid();
        accountData.hoster = account.getHoster();
        accountData.maxSimultanDownloads = account.getMaxSimultanDownloads();
        accountData.password = account.getPass();
        accountData.user = account.getUser();
        return accountData;
    }

    public HashMap<String, Object> getInfoProperties() {
        return this.infoProperties;
    }

    public void setInfoProperties(HashMap<String, Object> hashMap) {
        this.infoProperties = hashMap;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long l) {
        this.createTime = l;
    }

    public long getTrafficLeft() {
        return this.trafficLeft;
    }

    public void setTrafficLeft(long l) {
        this.trafficLeft = l;
    }

    public long getTrafficMax() {
        return this.trafficMax;
    }

    public void setTrafficMax(long l) {
        this.trafficMax = l;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(long l) {
        this.validUntil = l;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isTempDisabled() {
        return this.tempDisabled;
    }

    public void setTempDisabled(boolean bl) {
        this.tempDisabled = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean isTrafficUnlimited() {
        return this.trafficUnlimited;
    }

    public void setTrafficUnlimited(boolean bl) {
        this.trafficUnlimited = bl;
    }

    public boolean isSpecialtraffic() {
        return this.specialtraffic;
    }

    public void setSpecialtraffic(boolean bl) {
        this.specialtraffic = bl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public Account toAccount() {
        Account account = new Account(this.user, this.password);
        if (this.infoProperties != null) {
            AccountInfo accountInfo = new AccountInfo();
            account.setAccountInfo(accountInfo);
            accountInfo.setProperties(this.infoProperties);
            accountInfo.setCreateTime(this.createTime);
            accountInfo.setTrafficLeft(this.trafficLeft);
            accountInfo.setTrafficMax(this.trafficMax);
            accountInfo.setValidUntil(this.validUntil);
            accountInfo.setStatus(this.status);
            if (this.trafficUnlimited) {
                accountInfo.setUnlimitedTraffic();
            }
            accountInfo.setSpecialTraffic(this.specialtraffic);
        }
        account.setActive(this.active);
        account.setEnabled(this.enabled);
        account.setHoster(this.hoster);
        account.setMaxSimultanDownloads(this.maxSimultanDownloads);
        account.setPass(this.password);
        account.setProperties(this.properties);
        account.setTempDisabled(this.tempDisabled);
        account.setUser(this.user);
        account.setValid(this.valid);
        return account;
    }
}

