/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import jd.controlling.IOEQ;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;
import org.jdownloader.controlling.filter.FilterRule;
import org.jdownloader.controlling.filter.LinkFilterSettings;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.NoDownloadLinkException;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;

public class LinkFilterController
implements LinkCrawlerFilter {
    private static final LinkFilterController INSTANCE = new LinkFilterController(false);
    private ArrayList<LinkgrabberFilterRule> filter;
    private LinkFilterSettings config = JsonConfig.create(LinkFilterSettings.class);
    private ArrayList<LinkgrabberFilterRuleWrapper> denyFileFilter;
    private ArrayList<LinkgrabberFilterRuleWrapper> acceptFileFilter;
    private ArrayList<LinkgrabberFilterRuleWrapper> denyUrlFilter;
    private ArrayList<LinkgrabberFilterRuleWrapper> acceptUrlFilter;
    private ChangeEventSender eventSender = new ChangeEventSender();

    public static LinkFilterController getInstance() {
        return INSTANCE;
    }

    public static LinkFilterController createEmptyTestInstance() {
        return new LinkFilterController(true);
    }

    public ArrayList<LinkgrabberFilterRuleWrapper> getAcceptFileFilter() {
        return this.acceptFileFilter;
    }

    public ArrayList<LinkgrabberFilterRuleWrapper> getAcceptUrlFilter() {
        return this.acceptUrlFilter;
    }

    private LinkFilterController(boolean bl) {
        if (!bl) {
            this.filter = this.config.getFilterList();
            if (this.filter == null) {
                this.filter = new ArrayList();
            }
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LinkFilterController linkFilterController = LinkFilterController.this;
                    synchronized (linkFilterController) {
                        LinkFilterController.this.config.setFilterList(LinkFilterController.this.filter);
                    }
                }

                @Override
                public String toString() {
                    return "save filters...";
                }
            });
            this.updateInternal();
        } else {
            this.filter = new ArrayList();
        }
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    private void updateInternal() {
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList = new ArrayList<LinkgrabberFilterRuleWrapper>();
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList2 = new ArrayList<LinkgrabberFilterRuleWrapper>();
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList3 = new ArrayList<LinkgrabberFilterRuleWrapper>();
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList4 = new ArrayList<LinkgrabberFilterRuleWrapper>();
        for (LinkgrabberFilterRule linkgrabberFilterRule : this.filter) {
            if (!linkgrabberFilterRule.isEnabled() || !linkgrabberFilterRule.isValid()) continue;
            LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper = linkgrabberFilterRule.compile();
            if (linkgrabberFilterRule.isAccept()) {
                if (!linkgrabberFilterRuleWrapper.isRequiresLinkcheck()) {
                    arrayList2.add(linkgrabberFilterRuleWrapper);
                    continue;
                }
                arrayList4.add(linkgrabberFilterRuleWrapper);
                continue;
            }
            if (!linkgrabberFilterRuleWrapper.isRequiresLinkcheck()) {
                arrayList.add(linkgrabberFilterRuleWrapper);
                continue;
            }
            arrayList3.add(linkgrabberFilterRuleWrapper);
        }
        arrayList.trimToSize();
        this.denyUrlFilter = arrayList;
        arrayList2.trimToSize();
        this.acceptUrlFilter = arrayList2;
        arrayList3.trimToSize();
        this.denyFileFilter = arrayList3;
        arrayList4.trimToSize();
        this.acceptFileFilter = arrayList4;
        this.getEventSender().fireEvent(new ChangeEvent(this));
    }

    public void update() {
        IOEQ.add(new Runnable(){

            @Override
            public void run() {
                LinkFilterController.this.updateInternal();
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LinkgrabberFilterRule> list() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            return new ArrayList<LinkgrabberFilterRule>(this.filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayList<LinkgrabberFilterRule> arrayList) {
        if (arrayList == null) {
            return;
        }
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            this.filter.addAll(arrayList);
            this.config.setFilterList(this.filter);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LinkgrabberFilterRule linkgrabberFilterRule) {
        if (linkgrabberFilterRule == null) {
            return;
        }
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            this.filter.add(linkgrabberFilterRule);
            this.config.setFilterList(this.filter);
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LinkgrabberFilterRule linkgrabberFilterRule) {
        if (linkgrabberFilterRule == null) {
            return;
        }
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            this.filter.remove(linkgrabberFilterRule);
            this.config.setFilterList(this.filter);
            this.update();
        }
    }

    @Override
    public boolean dropByUrl(CrawledLink crawledLink) {
        if (crawledLink.getMatchingFilter() != null) {
            return false;
        }
        if (!((Boolean)CFG_LINKFILTER.LINK_FILTER_ENABLED.getValue()).booleanValue()) {
            return false;
        }
        boolean bl = false;
        LinkgrabberFilterRule linkgrabberFilterRule = null;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList = this.denyUrlFilter;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList2 = this.acceptUrlFilter;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList3 = this.acceptFileFilter;
        if (arrayList.size() > 0) {
            for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList) {
                try {
                    if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                    }
                }
                catch (NoDownloadLinkException noDownloadLinkException) {}
                continue;
                try {
                    if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                    }
                }
                catch (NoDownloadLinkException noDownloadLinkException) {}
                continue;
                if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink)) continue;
                bl = true;
                linkgrabberFilterRule = (LinkgrabberFilterRule)linkgrabberFilterRuleWrapper.getRule();
            }
        }
        if (!bl) {
            return false;
        }
        for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList2) {
            try {
                if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                return false;
            }
            try {
                if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                return false;
            }
            if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink)) continue;
            crawledLink.setMatchingFilter((FilterRule)linkgrabberFilterRuleWrapper.getRule());
            return false;
        }
        for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList3) {
            try {
                if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                return false;
            }
            try {
                if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                return false;
            }
            if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink)) continue;
            crawledLink.setMatchingFilter((FilterRule)linkgrabberFilterRuleWrapper.getRule());
            return false;
        }
        crawledLink.setMatchingFilter(linkgrabberFilterRule);
        return true;
    }

    @Override
    public boolean dropByFileProperties(CrawledLink crawledLink) {
        if (crawledLink.getMatchingFilter() != null && crawledLink.getMatchingFilter() instanceof LinkgrabberFilterRule && !((LinkgrabberFilterRule)crawledLink.getMatchingFilter()).isAccept()) {
            return false;
        }
        if (!((Boolean)CFG_LINKFILTER.LINK_FILTER_ENABLED.getValue()).booleanValue()) {
            return false;
        }
        DownloadLink downloadLink = crawledLink.getDownloadLink();
        if (downloadLink == null) {
            throw new WTFException();
        }
        boolean bl = false;
        LinkgrabberFilterRule linkgrabberFilterRule = null;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList = this.denyUrlFilter;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList2 = this.acceptUrlFilter;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList3 = this.acceptFileFilter;
        ArrayList<LinkgrabberFilterRuleWrapper> arrayList4 = this.denyFileFilter;
        if (arrayList4.size() > 0 || arrayList.size() > 0) {
            for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList4) {
                try {
                    if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                        continue;
                    }
                }
                catch (NoDownloadLinkException noDownloadLinkException) {
                    throw new WTFException();
                }
                try {
                    if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                        continue;
                    }
                }
                catch (NoDownloadLinkException noDownloadLinkException) {
                    throw new WTFException();
                }
                if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink) || !linkgrabberFilterRuleWrapper.checkOnlineStatus(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileName(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileSize(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileType(crawledLink)) continue;
                bl = true;
                linkgrabberFilterRule = (LinkgrabberFilterRule)linkgrabberFilterRuleWrapper.getRule();
                break;
            }
            if (!bl) {
                for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList) {
                    try {
                        if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                            continue;
                        }
                    }
                    catch (NoDownloadLinkException noDownloadLinkException) {
                        throw new WTFException();
                    }
                    try {
                        if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                            continue;
                        }
                    }
                    catch (NoDownloadLinkException noDownloadLinkException) {
                        throw new WTFException();
                    }
                    if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink)) continue;
                    bl = true;
                    linkgrabberFilterRule = (LinkgrabberFilterRule)linkgrabberFilterRuleWrapper.getRule();
                }
            }
        }
        if (!bl) {
            return false;
        }
        for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList2) {
            try {
                if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                noDownloadLinkException.printStackTrace();
                throw new WTFException();
            }
            try {
                if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink)) continue;
            crawledLink.setMatchingFilter((FilterRule)linkgrabberFilterRuleWrapper.getRule());
            return false;
        }
        for (LinkgrabberFilterRuleWrapper linkgrabberFilterRuleWrapper : arrayList3) {
            try {
                if (!linkgrabberFilterRuleWrapper.checkHoster(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            try {
                if (!linkgrabberFilterRuleWrapper.checkPluginStatus(crawledLink)) {
                    continue;
                }
            }
            catch (NoDownloadLinkException noDownloadLinkException) {
                throw new WTFException();
            }
            if (!linkgrabberFilterRuleWrapper.checkSource(crawledLink) || !linkgrabberFilterRuleWrapper.checkOnlineStatus(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileName(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileSize(crawledLink) || !linkgrabberFilterRuleWrapper.checkFileType(crawledLink)) continue;
            crawledLink.setMatchingFilter((FilterRule)linkgrabberFilterRuleWrapper.getRule());
            return false;
        }
        crawledLink.setMatchingFilter(linkgrabberFilterRule);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LinkgrabberFilterRule> listFilters() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            ArrayList<LinkgrabberFilterRule> arrayList = this.filter;
            ArrayList<LinkgrabberFilterRule> arrayList2 = new ArrayList<LinkgrabberFilterRule>();
            for (LinkgrabberFilterRule linkgrabberFilterRule : arrayList) {
                if (linkgrabberFilterRule.isAccept()) continue;
                arrayList2.add(linkgrabberFilterRule);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LinkgrabberFilterRule> listExceptions() {
        LinkFilterController linkFilterController = this;
        synchronized (linkFilterController) {
            ArrayList<LinkgrabberFilterRule> arrayList = this.filter;
            ArrayList<LinkgrabberFilterRule> arrayList2 = new ArrayList<LinkgrabberFilterRule>();
            for (LinkgrabberFilterRule linkgrabberFilterRule : arrayList) {
                if (!linkgrabberFilterRule.isAccept()) continue;
                arrayList2.add(linkgrabberFilterRule);
            }
            return arrayList2;
        }
    }
}

