/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appwork.utils.Hash;
import org.appwork.utils.zip.ZipIOException;

public class ZipIOWriter {
    private ZipOutputStream zipStream = null;
    private OutputStream fileStream = null;
    private File zipFile = null;
    private final byte[] buf = new byte[8192];

    public ZipIOWriter(ByteArrayOutputStream byteArrayOutputStream) throws FileNotFoundException, ZipIOException {
        this.fileStream = byteArrayOutputStream;
        this.zipStream = new ZipOutputStream(this.fileStream);
    }

    public ZipIOWriter(File file) throws FileNotFoundException, ZipIOException {
        this.zipFile = file;
        this.openZip(false);
    }

    public ZipIOWriter(File file, boolean bl) throws FileNotFoundException, ZipIOException {
        this.zipFile = file;
        this.openZip(bl);
    }

    public synchronized void add(File file, boolean bl, String string) throws ZipIOException, IOException {
        if (file == null || !file.exists()) {
            throw new ZipIOException("add " + file.getAbsolutePath() + " invalid");
        }
        if (file.isFile()) {
            this.addFileInternal(file, bl, string);
        } else if (file.isDirectory()) {
            this.addDirectoryInternal(file, bl, string);
        } else {
            throw new ZipIOException("add " + file.getAbsolutePath() + " invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addByteArry(byte[] byArray, boolean bl, String string, String string2) throws IOException, ZipIOException {
        boolean bl2 = false;
        try {
            if (byArray == null) {
                throw new ZipIOException("data array is invalid");
            }
            ZipEntry zipEntry = new ZipEntry((string != null && string.trim().length() > 0 ? string + "/" : "") + string2);
            zipEntry.setSize(byArray.length);
            if (bl) {
                zipEntry.setMethod(8);
            } else {
                zipEntry.setMethod(0);
                zipEntry.setCompressedSize(byArray.length);
                zipEntry.setCrc(Hash.getCRC32(byArray));
            }
            this.zipStream.putNextEntry(zipEntry);
            bl2 = true;
            this.zipStream.write(byArray, 0, byArray.length);
        }
        finally {
            if (bl2) {
                this.zipStream.closeEntry();
            }
        }
    }

    public synchronized void addDirectory(File file, boolean bl, String string) throws ZipIOException, IOException {
        this.addDirectoryInternal(file, bl, string);
    }

    private void addDirectoryInternal(File file, boolean bl, String string) throws ZipIOException, IOException {
        if (file == null || !file.isDirectory() || !file.exists()) {
            throw new ZipIOException("addDirectory " + file.getAbsolutePath() + " invalid");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                this.addFileInternal(file2, bl, (string != null && string.trim().length() > 0 ? string + "/" : "") + file.getName());
                continue;
            }
            if (file2.isDirectory()) {
                this.addDirectoryInternal(file2, bl, (string != null && string.trim().length() > 0 ? string + "/" : "") + file.getName());
                continue;
            }
            throw new ZipIOException("addDirectory " + file.getAbsolutePath() + " invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, boolean bl, String string) throws ZipIOException, IOException, FileNotFoundException {
        FileInputStream fileInputStream = null;
        boolean bl2 = false;
        try {
            int n;
            if (file == null || !file.isFile() || !file.exists()) {
                throw new ZipIOException("addFile " + file.getAbsolutePath() + " invalid");
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(file.length());
            if (bl) {
                zipEntry.setMethod(8);
            } else {
                zipEntry.setMethod(0);
                zipEntry.setCompressedSize(file.length());
                zipEntry.setCrc(Hash.getCRC32(file));
            }
            fileInputStream = new FileInputStream(file);
            this.zipStream.putNextEntry(zipEntry);
            bl2 = true;
            while ((n = fileInputStream.read(this.buf)) > 0) {
                this.zipStream.write(this.buf, 0, n);
            }
        }
        finally {
            if (bl2) {
                this.zipStream.closeEntry();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void addFileInternal(File file, boolean bl, String string) throws ZipIOException, IOException {
        String string2 = (string != null && string.trim().length() > 0 ? string + "/" : "") + file.getName();
        this.addFile(file, bl, string2);
    }

    public synchronized void addFileToPath(File file, boolean bl, String string) throws ZipIOException, IOException {
        this.addFileInternal(file, bl, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            try {
                this.zipStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fileStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.zipStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fileStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.zipStream = null;
            this.fileStream = null;
        }
    }

    private void openZip(boolean bl) throws ZipIOException, FileNotFoundException {
        if (this.fileStream != null && this.zipStream != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory()) {
            throw new ZipIOException("invalid zipFile");
        }
        if (this.zipFile.exists() && !bl) {
            throw new ZipIOException("zipFile already exists");
        }
        this.fileStream = new FileOutputStream(this.zipFile);
        this.zipStream = new ZipOutputStream(this.fileStream);
    }
}

