/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.appwork.utils.Files;
import org.appwork.utils.logging.Log;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOFile;

public class ZipIOReader {
    private File zipFile = null;
    private ZipFile zip = null;
    private ZipIOFile rootFS = null;
    private boolean autoCreateExtractPath = true;
    private boolean overwrite = false;
    private boolean autoCreateSubDirs = true;
    private byte[] byteArray = null;
    private int zipEntriesSize = -1;
    private ZipEntry[] zipEntries = null;
    private boolean breakOnError = true;

    public ZipIOReader(byte[] byArray) {
        this.byteArray = byArray;
    }

    public ZipIOReader(File file) throws ZipIOException, ZipException, IOException {
        this.zipFile = file;
        this.openZip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        finally {
            this.byteArray = null;
            this.zip = null;
        }
    }

    public synchronized ArrayList<File> extract(ZipEntry zipEntry, File file) throws ZipIOException, IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists() && file.isDirectory()) {
            if (this.isOverwrite()) {
                Files.deleteRecursiv(file);
                if (file.exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot extract File to Directory " + file);
                    }
                    Log.L.severe("Cannot extract File to Directory " + file);
                }
            }
            if (file.exists() && file.isDirectory()) {
                Log.L.finer("Skipped extraction: directory exists: " + file);
                return arrayList;
            }
        }
        if (file.exists()) {
            if (this.isOverwrite()) {
                file.delete();
                if (file.exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot overwrite File " + file);
                    }
                    Log.L.severe("Cannot overwrite File " + file);
                }
            }
            if (file.exists()) {
                Log.L.finer("Skipped extraction: file exists: " + file);
                return arrayList;
            }
        }
        if (!file.getParentFile().exists()) {
            if (this.isAutoCreateSubDirs()) {
                file.getParentFile().mkdirs();
                arrayList.add(file.getParentFile());
                if (!file.getParentFile().exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot create folder for File " + file);
                    }
                    Log.L.severe("Cannot create folder for File " + file);
                }
            }
            if (!file.getParentFile().exists()) {
                Log.L.finer("Skipped extraction: cannot create dir: " + file);
                return arrayList;
            }
        }
        this.extract(zipEntry, new FileOutputStream(file));
        arrayList.add(file);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(ZipEntry zipEntry, OutputStream outputStream) throws ZipIOException, IOException {
        if (zipEntry.isDirectory()) {
            if (this.isBreakOnError()) {
                throw new ZipIOException("Cannot extract a directory", zipEntry);
            }
            Log.L.severe("Cannot extract a directory " + zipEntry.getName());
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = this.getInputStream(zipEntry);
            filterInputStream = new CheckedInputStream(inputStream, new CRC32());
            byte[] byArray = new byte[Short.MAX_VALUE];
            int n = 0;
            while ((n = filterInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            if (zipEntry.getCrc() != -1L && zipEntry.getCrc() != ((CheckedInputStream)filterInputStream).getChecksum().getValue()) {
                if (this.isBreakOnError()) {
                    throw new ZipIOException("CRC32 Failed", zipEntry);
                }
                Log.L.severe("CRC32 Failed " + zipEntry);
            }
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized ArrayList<File> extractTo(File file) throws ZipIOException, IOException {
        if (file.exists() && file.isFile()) {
            if (this.isBreakOnError()) {
                throw new IOException("cannot extract to a file " + file);
            }
            Log.L.severe("cannot extract to a file " + file);
        }
        if (!(file.exists() || this.autoCreateExtractPath && file.mkdirs())) {
            if (this.isBreakOnError()) {
                throw new IOException("could not create outputDirectory " + file);
            }
            Log.L.severe("could not create outputDirectory " + file);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (ZipEntry zipEntry : this.getZipFiles()) {
            File file2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (file2.exists()) continue;
                if (this.isAutoCreateSubDirs()) {
                    if (!file2.mkdir()) {
                        if (this.isBreakOnError()) {
                            throw new IOException("could not create outputDirectory " + file2);
                        }
                        Log.L.severe("could not create outputDirectory " + file2);
                    }
                    arrayList.add(file2);
                    continue;
                }
                Log.L.finer("SKipped creatzion of: " + file2);
                continue;
            }
            arrayList.addAll(this.extract(zipEntry, file2));
        }
        return arrayList;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public void setBreakOnError(boolean bl) {
        this.breakOnError = bl;
    }

    private ZipIOFile getFolder(String string, ZipIOFile zipIOFile) {
        if (string == null || zipIOFile == null || !zipIOFile.isDirectory()) {
            return null;
        }
        if (zipIOFile.getAbsolutePath().equalsIgnoreCase(string)) {
            return zipIOFile;
        }
        for (ZipIOFile zipIOFile2 : zipIOFile.getFiles()) {
            ZipIOFile zipIOFile3;
            if (zipIOFile2.isDirectory() && zipIOFile2.getAbsolutePath().equalsIgnoreCase(string)) {
                return zipIOFile2;
            }
            if (!zipIOFile2.isDirectory() || (zipIOFile3 = this.getFolder(string, zipIOFile2)) == null) continue;
            return zipIOFile3;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws ZipIOException, IOException {
        if (zipEntry == null) {
            throw new ZipIOException("invalid zipEntry");
        }
        if (this.zip != null) {
            return this.zip.getInputStream(zipEntry);
        }
        ZipInputStream zipInputStream = null;
        boolean bl = true;
        try {
            zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
            ZipEntry zipEntry2 = null;
            while (true) {
                if ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    String string = zipEntry2.getName();
                    if (!string.equals(zipEntry.getName())) continue;
                    final ZipInputStream zipInputStream2 = zipInputStream;
                    bl = false;
                    InputStream inputStream = new InputStream(){

                        @Override
                        public void close() throws IOException {
                            zipInputStream2.close();
                        }

                        @Override
                        public int read() throws IOException {
                            return zipInputStream2.read();
                        }

                        @Override
                        public int read(byte[] byArray) throws IOException {
                            return zipInputStream2.read(byArray);
                        }

                        @Override
                        public int read(byte[] byArray, int n, int n2) throws IOException {
                            return zipInputStream2.read(byArray, n, n2);
                        }
                    };
                    return inputStream;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new ZipIOException(iOException.getMessage(), iOException);
        }
        finally {
            try {
                if (bl) {
                    zipInputStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public synchronized ZipEntry getZipFile(String string) throws ZipIOException {
        if (string == null) {
            throw new ZipIOException("invalid fileName");
        }
        if (this.zip != null) {
            return this.zip.getEntry(string);
        }
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string)) continue;
                ZipEntry zipEntry2 = zipEntry;
                return zipEntry2;
            }
            ZipEntry zipEntry3 = null;
            return zipEntry3;
        }
        catch (IOException iOException) {
            throw new ZipIOException(iOException.getMessage(), iOException);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized ZipEntry[] getZipFiles() throws ZipIOException {
        if (this.zipEntries != null) {
            return this.zipEntries;
        }
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
        if (this.zip != null) {
            Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        } else {
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    arrayList.add(zipEntry);
                }
            }
            catch (IOException iOException) {
                throw new ZipIOException(iOException.getMessage(), iOException);
            }
            finally {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.zipEntries = arrayList.toArray(new ZipEntry[arrayList.size()]);
        return this.zipEntries;
    }

    public synchronized ZipIOFile getZipIOFileSystem() throws ZipIOException {
        if (this.rootFS != null) {
            return this.rootFS;
        }
        ZipEntry[] zipEntryArray = this.getZipFiles();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ZipEntry zipEntry : zipEntryArray) {
            Object object;
            if (!zipEntry.isDirectory() && !zipEntry.getName().contains("/")) {
                object = new ZipIOFile(zipEntry.getName(), zipEntry, this, null);
                arrayList.add(object);
                continue;
            }
            if (zipEntry.isDirectory()) continue;
            object = zipEntry.getName().split("/");
            Object object2 = null;
            String string = "";
            for (int i = 0; i < ((String[])object).length; ++i) {
                ZipIOFile zipIOFile;
                ZipIOFile zipIOFile2;
                if (i == ((String[])object).length - 1) {
                    zipIOFile2 = new ZipIOFile(object[i], zipEntry, this, (ZipIOFile)object2);
                    ((ZipIOFile)object2).getFilesInternal().add(zipIOFile2);
                    continue;
                }
                string = string + object[i] + "/";
                zipIOFile2 = null;
                Object object3 = arrayList.iterator();
                while (object3.hasNext() && (zipIOFile2 = this.getFolder(string, zipIOFile = (ZipIOFile)object3.next())) == null) {
                }
                if (zipIOFile2 != null) {
                    object2 = zipIOFile2;
                    continue;
                }
                object3 = new ZipIOFile(object[i], null, this, (ZipIOFile)object2);
                if (object2 != null) {
                    ((ZipIOFile)object2).getFilesInternal().add((ZipIOFile)object3);
                } else {
                    arrayList.add(object3);
                }
                object2 = object3;
            }
        }
        this.rootFS = new ZipIOFile("", null, this, null);
        this.rootFS.getFilesInternal().addAll(arrayList);
        this.rootFS.getFilesInternal().trimToSize();
        this.trimZipIOFiles(this.rootFS);
        return this.rootFS;
    }

    public boolean isAutoCreateExtractPath() {
        return this.autoCreateExtractPath;
    }

    protected boolean isAutoCreateSubDirs() {
        return this.autoCreateSubDirs;
    }

    protected boolean isOverwrite() {
        return this.overwrite;
    }

    private synchronized void openZip() throws ZipIOException, ZipException, IOException {
        if (this.zip != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory() || !this.zipFile.exists()) {
            throw new ZipIOException("invalid zipFile");
        }
        this.zip = new ZipFile(this.zipFile);
    }

    public void setAutoCreateExtractPath(boolean bl) {
        this.autoCreateExtractPath = bl;
    }

    public void setAutoCreateSubDirs(boolean bl) {
        this.autoCreateSubDirs = bl;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public synchronized int size() throws ZipIOException {
        if (this.zipEntriesSize != -1) {
            return this.zipEntriesSize;
        }
        if (this.zip != null) {
            this.zipEntriesSize = this.zip.size();
        } else {
            ZipInputStream zipInputStream = null;
            try {
                this.zipEntriesSize = 0;
                zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
                while (zipInputStream.getNextEntry() != null) {
                    ++this.zipEntriesSize;
                }
            }
            catch (IOException iOException) {
                throw new ZipIOException(iOException.getMessage(), iOException);
            }
            finally {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.zipEntriesSize;
    }

    private void trimZipIOFiles(ZipIOFile zipIOFile) {
        if (zipIOFile == null) {
            return;
        }
        for (ZipIOFile zipIOFile2 : zipIOFile.getFiles()) {
            if (!zipIOFile2.isDirectory()) continue;
            this.trimZipIOFiles(zipIOFile2);
        }
        zipIOFile.getFilesInternal().trimToSize();
    }
}

